/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.label.AlphabeticalLabelGroupingSupport;
import com.atlassian.jira.issue.label.AlphabeticalLabelRenderer;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class DefaultAlphabeticalLabelRenderer
implements AlphabeticalLabelRenderer {
    private static final Logger log = Logger.getLogger(DefaultAlphabeticalLabelRenderer.class);
    private final VelocityTemplatingEngine templatingEngine;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final LabelUtil labelUtil;
    private final I18nHelper.BeanFactory beanFactory;

    public DefaultAlphabeticalLabelRenderer(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, FieldManager fieldManager, ProjectManager projectManager, LabelUtil labelUtil, I18nHelper.BeanFactory beanFactory) {
        this.templatingEngine = templatingEngine;
        this.authenticationContext = authenticationContext;
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.labelUtil = labelUtil;
        this.beanFactory = beanFactory;
    }

    @Override
    public String getHtml(User remoteUser, Long projectId, String fieldId) {
        StatisticAccessorBean statBean = new StatisticAccessorBean(remoteUser, this.getProjectFilter(projectId));
        try {
            StatisticMapWrapper statWrapper = statBean.getAllFilterBy(fieldId, StatisticAccessorBean.OrderBy.NATURAL, StatisticAccessorBean.Direction.ASC);
            HashSet<String> uniqueLabels = new HashSet<String>();
            for (Label label : statWrapper.keySet()) {
                if (label == null || label.getLabel() == null) continue;
                uniqueLabels.add(label.getLabel());
            }
            AlphabeticalLabelGroupingSupport alphaSupport = new AlphabeticalLabelGroupingSupport(uniqueLabels);
            Map<String, Object> startingParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
            startingParams.put("field", this.fieldManager.getField(fieldId));
            startingParams.put("project", this.projectManager.getProjectObj(projectId));
            startingParams.put("labelUtils", this.labelUtil);
            startingParams.put("labelCount", uniqueLabels.size());
            startingParams.put("alphaSupport", alphaSupport);
            startingParams.put("isCustomField", fieldId.startsWith("customfield_"));
            startingParams.put("remoteUser", remoteUser);
            startingParams.put("i18n", this.beanFactory.getInstance(remoteUser));
            return this.templatingEngine.render(TemplateSources.file((String)"templates/plugins/jira/projectpanels/labels-alphabetical.vm")).applying(startingParams).asHtml();
        }
        catch (SearchException e) {
            log.error((Object)"Error gathering label stats", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
    }

    private SearchRequest getProjectFilter(Long projectId) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        jqlClauseBuilder.project(new Long[]{projectId});
        return new SearchRequest(jqlClauseBuilder.buildQuery());
    }
}

