/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class MultiSelectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = Logger.getLogger(MultiSelectCustomFieldIndexer.class);
    private final CustomField customField;

    public MultiSelectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        try {
            Object value = this.customField.getValue(issue);
            if (value == null) {
                return;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                for (Option o : col) {
                    if (o == null) continue;
                    String indexValue = o.getOptionId().toString();
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), indexValue, Field.Store.YES, indexType));
                    doc.add((Fieldable)new Field(this.getDocumentFieldId() + "_raw", indexValue, Field.Store.YES, indexType));
                }
            } else if (value instanceof Option) {
                String indexValue = ((Option)value).getOptionId().toString();
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), indexValue, Field.Store.YES, indexType));
                doc.add((Fieldable)new Field(this.getDocumentFieldId() + "_raw", indexValue, Field.Store.YES, indexType));
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Invalid custom field option");
        }
    }
}

