/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.screen.AbstractFieldScreenLayoutItemEvent;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingFieldScreenStore
implements FieldScreenStore {
    private static final Logger log = LoggerFactory.getLogger(CachingFieldScreenStore.class);
    private final FieldScreenStore decoratedStore;
    private final ResettableLazyReference<FieldScreenCache> cache = new ResettableLazyReference<FieldScreenCache>(){

        protected FieldScreenCache create() throws Exception {
            return new FieldScreenCache();
        }
    };

    public CachingFieldScreenStore(FieldScreenStore decoratedStore) {
        this.decoratedStore = decoratedStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public void setFieldScreenManager(FieldScreenManager fieldScreenManager) {
        this.decoratedStore.setFieldScreenManager(fieldScreenManager);
    }

    @Override
    public FieldScreen getFieldScreen(Long id) {
        return ((FieldScreenCache)this.cache.get()).getFieldScreen(id);
    }

    @Override
    public List<FieldScreen> getFieldScreens() {
        return ((FieldScreenCache)this.cache.get()).getFieldScreens();
    }

    @Override
    public void createFieldScreen(FieldScreen fieldScreen) {
        this.decoratedStore.createFieldScreen(fieldScreen);
        this.refresh();
    }

    @Override
    public void removeFieldScreen(Long id) {
        this.decoratedStore.removeFieldScreen(id);
        this.refresh();
    }

    @Override
    public void updateFieldScreen(FieldScreen fieldScreen) {
        this.decoratedStore.updateFieldScreen(fieldScreen);
        this.refresh();
    }

    @Override
    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.createFieldScreenTab(fieldScreenTab);
    }

    @Override
    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.updateFieldScreenTab(fieldScreenTab);
    }

    @Override
    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        return this.decoratedStore.getFieldScreenTabs(fieldScreen);
    }

    @Override
    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.updateFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.removeFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.removeFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        return this.decoratedStore.getFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public void refresh() {
        this.cache.reset();
        this.cache.get();
        this.decoratedStore.refresh();
        if (log.isTraceEnabled()) {
            log.trace("Called refresh()", new Throwable());
        }
    }

    @EventListener
    public void onFieldScreenLayoutChange(AbstractFieldScreenLayoutItemEvent event) {
        ((FieldScreenCache)this.cache.get()).refreshSingle(event.getFieldScreenId());
    }

    @Override
    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.createFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(GenericValue genericValue) {
        return this.decoratedStore.buildNewFieldScreenLayoutItem(genericValue);
    }

    @Override
    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.decoratedStore.removeFieldScreenTabs(fieldScreen);
    }

    @Override
    public void removeFieldScreenTab(Long id) {
        this.decoratedStore.removeFieldScreenTab(id);
    }

    @Override
    public FieldScreenTab getFieldScreenTab(Long tabId) {
        return this.decoratedStore.getFieldScreenTab(tabId);
    }

    private static class ScreenNameComparator
    implements Comparator<FieldScreen> {
        private ScreenNameComparator() {
        }

        @Override
        public int compare(FieldScreen fs1, FieldScreen fs2) {
            return fs1.getName().compareTo(fs2.getName());
        }
    }

    private static class IndexById
    implements Function<FieldScreen, Long> {
        private IndexById() {
        }

        public Long apply(@Nullable FieldScreen fieldScreen) {
            return fieldScreen != null ? fieldScreen.getId() : null;
        }
    }

    @Immutable
    class ImmutableFieldScreenCache {
        private final ImmutableMap<Long, FieldScreen> fieldScreenById;
        private final ImmutableList<FieldScreen> fieldScreens;

        public ImmutableFieldScreenCache(Map<Long, FieldScreen> fieldScreenById) {
            this.fieldScreenById = ImmutableMap.copyOf(this.deepCopyOf(fieldScreenById));
            this.fieldScreens = Ordering.from((Comparator)new ScreenNameComparator()).immutableSortedCopy((Iterable)this.fieldScreenById.values());
        }

        public FieldScreen getFieldScreen(Long id) {
            FieldScreen fieldScreen = (FieldScreen)this.fieldScreenById.get((Object)id);
            return fieldScreen != null ? this.deepCopyOf(fieldScreen) : null;
        }

        public List<FieldScreen> getFieldScreens() {
            return this.deepCopyOf((Collection<FieldScreen>)this.fieldScreens);
        }

        public ImmutableFieldScreenCache makeCopyContaining(FieldScreen fieldScreen) {
            ImmutableMap.Builder copyOfFieldScreenById = ImmutableMap.builder();
            for (Map.Entry screen : this.fieldScreenById.entrySet()) {
                if (((Long)screen.getKey()).equals(fieldScreen.getId())) continue;
                copyOfFieldScreenById.put(screen.getKey(), screen.getValue());
            }
            copyOfFieldScreenById.put((Object)fieldScreen.getId(), (Object)fieldScreen);
            return new ImmutableFieldScreenCache((Map<Long, FieldScreen>)copyOfFieldScreenById.build());
        }

        private Map<Long, FieldScreen> deepCopyOf(Map<Long, FieldScreen> fieldScreenById) {
            HashMap copyOfMap = Maps.newHashMapWithExpectedSize((int)fieldScreenById.size());
            for (Map.Entry<Long, FieldScreen> fieldScreen : fieldScreenById.entrySet()) {
                copyOfMap.put(fieldScreen.getKey(), this.deepCopyOf(fieldScreen.getValue()));
            }
            return copyOfMap;
        }

        private List<FieldScreen> deepCopyOf(Collection<FieldScreen> fieldScreens) {
            ArrayList copyOfList = Lists.newArrayListWithCapacity((int)fieldScreens.size());
            for (FieldScreen fieldScreen : fieldScreens) {
                copyOfList.add(this.deepCopyOf(fieldScreen));
            }
            return copyOfList;
        }

        private FieldScreen deepCopyOf(FieldScreen fieldScreen) {
            if (fieldScreen instanceof FieldScreenImpl) {
                return ((FieldScreenImpl)fieldScreen).deepCopy();
            }
            return fieldScreen;
        }
    }

    class FieldScreenCache {
        private volatile ImmutableFieldScreenCache data;

        FieldScreenCache() {
            List<FieldScreen> dbFieldScreens = CachingFieldScreenStore.this.decoratedStore.getFieldScreens();
            this.data = new ImmutableFieldScreenCache((Map<Long, FieldScreen>)Maps.uniqueIndex(dbFieldScreens, (Function)new IndexById()));
        }

        synchronized void refreshSingle(Long fieldScreenId) {
            FieldScreen dbFieldScreen = CachingFieldScreenStore.this.decoratedStore.getFieldScreen(fieldScreenId);
            this.data = this.data.makeCopyContaining(dbFieldScreen);
        }

        FieldScreen getFieldScreen(Long id) {
            return this.data.getFieldScreen(id);
        }

        List<FieldScreen> getFieldScreens() {
            return this.data.getFieldScreens();
        }
    }
}

