/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.ProjectSearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparator;
import com.atlassian.jira.issue.statistics.ProjectStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class ProjectSystemField
extends AbstractOrderableNavigableFieldImpl
implements ProjectField,
RestAwareField {
    public static final String PROJECT_NAME_KEY = "issue.field.project";
    private static final String FIELD_PARAMETER_NAME = "pid";
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final ProjectStatisticsMapper projectStatisticsMapper;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserProjectHistoryManager projectHistoryManager;

    public ProjectSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ProjectManager projectManager, PermissionManager permissionManager, ProjectStatisticsMapper projectStatisticsMapper, ProjectSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls, UserProjectHistoryManager projectHistoryManager) {
        super("project", PROJECT_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectStatisticsMapper = projectStatisticsMapper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectHistoryManager = projectHistoryManager;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Long projectId = (Long)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put(this.getId(), projectId);
        User user = this.authenticationContext.getLoggedInUser();
        Collection projects = this.permissionManager.getProjectObjects(11, user);
        List recentProjects = this.projectHistoryManager.getProjectHistoryWithPermissionChecks(11, user);
        recentProjects = recentProjects.subList(0, Math.min(6, recentProjects.size()));
        velocityParams.put("projects", projects);
        velocityParams.put("recentProjects", recentProjects);
        return this.renderTemplate("project-edit.vm", velocityParams);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Project field cannot be edited.");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(null, action, null, displayParameters);
        Long projectId = (Long)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put(this.getId(), projectId);
        Collection allowedProjects = this.getAllowedProjects();
        velocityParams.put("projects", allowedProjects);
        return this.renderTemplate("project-edit.vm", velocityParams);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        try {
            Map fieldValuesHolder = operationContext.getFieldValuesHolder();
            Long projectId = (Long)fieldValuesHolder.get(this.getId());
            if (projectId != null) {
                GenericValue project = this.getProject(projectId);
                if (project == null) {
                    errorCollectionToAddTo.addError(FIELD_PARAMETER_NAME, i18n.getText("createissue.invalidproject"), ErrorCollection.Reason.VALIDATION_FAILED);
                } else if (!this.getAllowedProjects().contains(project)) {
                    if (this.authenticationContext.getLoggedInUser() != null) {
                        errorCollectionToAddTo.addError(FIELD_PARAMETER_NAME, i18n.getText("createissue.projectnopermission"), ErrorCollection.Reason.FORBIDDEN);
                    } else {
                        errorCollectionToAddTo.addError(FIELD_PARAMETER_NAME, i18n.getText("createissue.projectnopermission.notloggedin"), ErrorCollection.Reason.NOT_LOGGED_IN);
                    }
                } else if (issue.getParentObject() != null && !issue.getParentObject().getProjectObject().getId().equals(projectId)) {
                    errorCollectionToAddTo.addError(FIELD_PARAMETER_NAME, i18n.getText("createsubtask.error.notsameproject"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else {
                errorCollectionToAddTo.addError(FIELD_PARAMETER_NAME, i18n.getText("createissue.noproject"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        catch (NumberFormatException e) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.invalidproject"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(FIELD_PARAMETER_NAME);
        if (value != null && value.length > 0) {
            return new Long(value[0]);
        }
        return null;
    }

    protected GenericValue getProject(Long projectId) {
        return this.projectManager.getProject(projectId);
    }

    public Object getValueFromParams(Map params) {
        return this.getProject((Long)params.get(this.getId()));
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Collection getAllowedProjects() {
        return this.getPermissionManager().getProjects(11, this.getAuthenticationContext().getLoggedInUser());
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        throw new UnsupportedOperationException();
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), issue.getProject().getLong("id"));
    }

    public Object getDefaultValue(Issue issue) {
        throw new UnsupportedOperationException();
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        throw new UnsupportedOperationException("Project field cannot be changed.");
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        issue.setProject((GenericValue)this.getValueFromParams(fieldValueHolder));
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return issue.getProject() != null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.project";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.projectStatisticsMapper;
    }

    @Override
    public List<SortField> getSortFields(boolean sortOrder) {
        return Collections.singletonList(new SortField("projkey", (FieldComparatorSource)new StringSortComparator(), sortOrder));
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("project", issue.getProject());
        return this.renderTemplate("project-columnview.vm", velocityParams);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return ProjectSystemField.getJsonType();
    }

    public static JsonType getJsonType() {
        return JsonTypeBuilder.system((String)"project", (String)"project");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)ProjectJsonBean.shortBean((Project)issue.getProjectObject(), (JiraBaseUrls)this.jiraBaseUrls)));
    }
}

