/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.converters.GroupConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractSingleValueCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;

public class GroupCustomFieldSearchInputTransformer
extends AbstractSingleValueCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final CustomField customField;
    private final GroupConverter groupConverter;

    public GroupCustomFieldSearchInputTransformer(CustomField customField, ClauseNames clauseNames, String urlParameterName, GroupConverter groupConverter, CustomFieldInputHelper customFieldInputHelper) {
        super(customField, clauseNames, urlParameterName, customFieldInputHelper);
        this.customField = customField;
        this.groupConverter = groupConverter;
    }

    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        CustomFieldParams custParams = (CustomFieldParams)fieldValuesHolder.get((Object)this.customField.getId());
        if (custParams == null) {
            return;
        }
        String groupName = (String)custParams.getFirstValueForNullKey();
        try {
            this.groupConverter.getGroup(groupName);
        }
        catch (FieldValidationException e) {
            errors.addError(this.customField.getId(), i18nHelper.getText("admin.errors.could.not.find.groupname", groupName));
        }
    }

    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        return this.convertForNavigator(query).fitsNavigator();
    }
}

