/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.ProjectCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldClauseSanitiserValueGeneratingHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.ProjectCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.ProjectCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.AlwaysVisibleSearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.CustomFieldProjectStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.permission.ProjectClauseValueSanitiser;
import com.atlassian.jira.jql.query.ProjectCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ProjectResolver;
import com.atlassian.jira.jql.validator.ProjectValidator;
import com.atlassian.jira.jql.values.ProjectClauseValuesGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class ProjectSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final JqlOperandResolver jqlOperandResolver;
    private final ProjectConverter projectConverter;
    private final ProjectResolver projectResolver;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final UserProjectHistoryManager projectHistoryManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private I18nHelper.BeanFactory beanFactory;
    private final CustomFieldInputHelper customFieldInputHelper;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private volatile ClauseNames clauseNames;

    public ProjectSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, ProjectConverter projectConverter, ProjectResolver projectResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, ProjectManager projectManager, PermissionManager permissionManager, CustomFieldInputHelper customFieldInputHelper, UserProjectHistoryManager projectHistoryManager) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.projectConverter = projectConverter;
        this.projectResolver = projectResolver;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectHistoryManager = projectHistoryManager;
        this.customFieldInputHelper = (CustomFieldInputHelper)Assertions.notNull((String)"customFieldInputHelper", (Object)customFieldInputHelper);
        this.beanFactory = ComponentAccessor.getI18nHelperFactory();
    }

    public void init(CustomField field) {
        this.clauseNames = field.getClauseNames();
        ProjectCustomFieldIndexer indexer = new ProjectCustomFieldIndexer(this.fieldVisibilityManager, field, this.projectConverter);
        ProjectIndexInfoResolver projectIndexInfoResolver = new ProjectIndexInfoResolver(this.projectResolver);
        ProjectCustomFieldValueProvider customFieldValueProvider = new ProjectCustomFieldValueProvider(this.projectConverter);
        AlwaysVisibleSearchContextVisibilityChecker searchContextVisibilityChecker = new AlwaysVisibleSearchContextVisibilityChecker();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(this.clauseNames, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new ProjectCustomFieldSearchInputTransformer(this.searcherInformation.getId(), this.clauseNames, field, this.jqlOperandResolver, projectIndexInfoResolver, this.fieldFlagOperandRegistry, searchContextVisibilityChecker, this.projectResolver, this.customFieldInputHelper);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldClauseSanitiserValueGeneratingHandler(new ProjectValidator(this.projectResolver, this.jqlOperandResolver, this.permissionManager, this.projectManager, this.beanFactory), new ProjectCustomFieldClauseQueryFactory(field.getId(), this.projectResolver, this.jqlOperandResolver), new ProjectClauseValueSanitiser(this.permissionManager, this.jqlOperandResolver, this.projectResolver), new ProjectClauseValuesGenerator(this.permissionManager), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.PROJECT);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return new CustomFieldProjectStatisticsMapper(this.projectManager, customField, this.customFieldInputHelper, ComponentAccessor.getJiraAuthenticationContext());
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldProjectStatisticsMapper(this.projectManager, customField, this.customFieldInputHelper, ComponentAccessor.getJiraAuthenticationContext());
    }
}

