/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;

class WriterWrapper
implements Writer {
    private final IndexWriter writer;
    private final Configuration configuration;

    WriterWrapper(Supplier<IndexWriter> writerFactory, @NotNull Configuration configuration, @NotNull Index.UpdateMode mode) {
        this.configuration = (Configuration)Assertions.notNull((String)"configuration", (Object)configuration);
        this.writer = (IndexWriter)writerFactory.get();
    }

    WriterWrapper(final @NotNull Configuration configuration, final Index.UpdateMode mode) {
        this(new Supplier<IndexWriter>(){

            public IndexWriter get() {
                try {
                    IndexWriterConfiguration.WriterSettings writerSettings = configuration.getWriterSettings(mode);
                    IndexWriterConfig luceneConfig = writerSettings.getWriterConfiguration(configuration.getAnalyzer());
                    return new IndexWriter(configuration.getDirectory(), luceneConfig);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }, configuration, mode);
    }

    @Override
    public void addDocuments(@NotNull Collection<Document> documents) throws IOException {
        for (Document document : documents) {
            this.writer.addDocument((Document)Assertions.notNull((String)"document", (Object)document));
        }
    }

    @Override
    public void deleteDocuments(@NotNull Term identifyingTerm) throws IOException {
        this.writer.deleteDocuments((Term)Assertions.notNull((String)"identifyingTerm", (Object)identifyingTerm));
    }

    @Override
    public void updateDocuments(@NotNull Term identifyingTerm, @NotNull Collection<Document> documents) throws IOException {
        if (documents.size() == 1) {
            this.writer.updateDocument(identifyingTerm, documents.iterator().next());
        } else {
            this.writer.deleteDocuments(identifyingTerm);
            for (Document document : documents) {
                this.writer.addDocument(document);
            }
        }
    }

    @Override
    public void optimize() throws IOException {
        this.writer.optimize();
    }

    @Override
    public void commit() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

