/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.util.dbc.Null;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class NodeAssociationParserImpl
implements NodeAssociationParser {
    public static final String SOURCE_NODE_ID = "sourceNodeId";
    public static final String SOURCE_NODE_ENTITY = "sourceNodeEntity";
    public static final String SINK_NODE_ID = "sinkNodeId";
    public static final String SINK_NODE_ENTITY = "sinkNodeEntity";
    public static final String ASSOCIATION_TYPE = "associationType";

    @Override
    public ExternalNodeAssociation parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String sourceNodeId = (String)attributes.get(SOURCE_NODE_ID);
        String sourceNodeEntity = (String)attributes.get(SOURCE_NODE_ENTITY);
        String sinkNodeId = (String)attributes.get(SINK_NODE_ID);
        String sinkNodeEntity = (String)attributes.get(SINK_NODE_ENTITY);
        String associationType = (String)attributes.get(ASSOCIATION_TYPE);
        if (StringUtils.isEmpty((String)sourceNodeId)) {
            throw new ParseException("No 'sourceNodeId' field for NodeAssocation.");
        }
        if (StringUtils.isEmpty((String)sourceNodeEntity)) {
            throw new ParseException("No 'sourceNodeEntity' field for NodeAssocation.");
        }
        if (StringUtils.isEmpty((String)sinkNodeId)) {
            throw new ParseException("No 'sinkNodeId' field for NodeAssocation.");
        }
        if (StringUtils.isEmpty((String)sinkNodeEntity)) {
            throw new ParseException("No 'sinkNodeEntity' field for NodeAssocation.");
        }
        if (StringUtils.isEmpty((String)associationType)) {
            throw new ParseException("No 'associationType' field for NodeAssocation.");
        }
        return new ExternalNodeAssociation(sourceNodeId, sourceNodeEntity, sinkNodeId, sinkNodeEntity, associationType);
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalNodeAssociation nodeAssociation) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(SOURCE_NODE_ID, nodeAssociation.getSourceNodeId());
        attributes.put(SOURCE_NODE_ENTITY, nodeAssociation.getSourceNodeEntity());
        attributes.put(SINK_NODE_ID, nodeAssociation.getSinkNodeId());
        attributes.put(SINK_NODE_ENTITY, nodeAssociation.getSinkNodeEntity());
        attributes.put(ASSOCIATION_TYPE, nodeAssociation.getAssociationType());
        return new EntityRepresentationImpl("NodeAssociation", attributes);
    }
}

