/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalIssueLinkType;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.IssueLinkTypeMapper;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import com.atlassian.jira.imports.project.parser.IssueLinkParserImpl;
import com.atlassian.jira.imports.project.parser.IssueLinkTypeParser;
import com.atlassian.jira.imports.project.parser.IssueLinkTypeParserImpl;
import com.atlassian.jira.issue.IssueManager;
import java.util.Map;

public class IssueLinkMapperHandler
implements ImportEntityHandler {
    private IssueLinkParser issueLinkParser;
    private IssueLinkTypeParser issueLinkTypeParser;
    private final BackupSystemInformation backupSystemInformation;
    private final IssueManager issueManager;
    private final IssueLinkTypeMapper issueLinkTypeMapper;
    private final BackupProject backupProject;

    public IssueLinkMapperHandler(BackupProject backupProject, BackupSystemInformation backupSystemInformation, IssueManager issueManager, IssueLinkTypeMapper issueLinkTypeMapper) {
        this.backupProject = backupProject;
        this.backupSystemInformation = backupSystemInformation;
        this.issueManager = issueManager;
        this.issueLinkTypeMapper = issueLinkTypeMapper;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("IssueLink".equals(entityName)) {
            ExternalLink issueLink = this.getIssueLinkParser().parse(attributes);
            if (this.backupProject.containsIssue(issueLink.getSourceId())) {
                if (this.backupProject.containsIssue(issueLink.getDestinationId())) {
                    this.issueLinkTypeMapper.flagValueAsRequired(issueLink.getLinkType());
                } else if (this.currentSystemContainsIssueKey(this.backupSystemInformation.getIssueKeyForId(issueLink.getDestinationId()))) {
                    this.issueLinkTypeMapper.flagValueAsRequired(issueLink.getLinkType());
                }
            } else if (this.backupProject.containsIssue(issueLink.getDestinationId()) && this.currentSystemContainsIssueKey(this.backupSystemInformation.getIssueKeyForId(issueLink.getSourceId()))) {
                this.issueLinkTypeMapper.flagValueAsRequired(issueLink.getLinkType());
            }
        } else if ("IssueLinkType".equals(entityName)) {
            ExternalIssueLinkType issueLinkType = this.getIssueLinkTypeParser().parse(attributes);
            this.issueLinkTypeMapper.registerOldValue(issueLinkType.getId(), issueLinkType.getLinkname(), issueLinkType.getStyle());
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    private boolean currentSystemContainsIssueKey(String issueKey) {
        return this.issueManager.getIssueObject(issueKey) != null;
    }

    IssueLinkParser getIssueLinkParser() {
        if (this.issueLinkParser == null) {
            this.issueLinkParser = new IssueLinkParserImpl();
        }
        return this.issueLinkParser;
    }

    IssueLinkTypeParser getIssueLinkTypeParser() {
        if (this.issueLinkTypeParser == null) {
            this.issueLinkTypeParser = new IssueLinkTypeParserImpl();
        }
        return this.issueLinkTypeParser;
    }
}

