/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.hints;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.hints.Hint;
import com.atlassian.jira.hints.HintImpl;
import com.atlassian.jira.hints.HintManager;
import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.descriptors.JiraWebItemModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraWebLabel;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.web.model.WebLabel;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class DefaultHintManager
implements HintManager {
    private static final Logger log = Logger.getLogger(DefaultHintManager.class);
    public static final String ALL_HINTS_SECTION = "jira.hints/all";
    public static final String HINTS_PREFIX = "jira.hints/";
    private final Random random = new Random();
    private final JiraWebInterfaceManager webInterfaceManager;

    public DefaultHintManager(JiraWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public Hint getRandomHint(User user, JiraHelper jiraHelper) {
        return this.getRandomHint(this.getAllHints(user, jiraHelper));
    }

    public List<Hint> getAllHints(User user, JiraHelper jiraHelper) {
        return this.getHintsForSection(user, jiraHelper, ALL_HINTS_SECTION);
    }

    public Hint getHintForContext(User remoteUser, JiraHelper jiraHelper, HintManager.Context context) {
        Assertions.notNull((String)"context", (Object)context);
        return this.getRandomHint(this.getHintsForSection(remoteUser, jiraHelper, HINTS_PREFIX + context.toString()));
    }

    private Hint getRandomHint(List<Hint> hints) {
        if (hints.isEmpty()) {
            return null;
        }
        int randomPosition = this.random.nextInt(hints.size());
        return hints.get(randomPosition);
    }

    private List<Hint> getHintsForSection(final User user, final JiraHelper helper, String section) {
        Assertions.notNull((String)"helper", (Object)helper);
        List items = this.webInterfaceManager.getDisplayableItems(section, user, helper);
        return CollectionUtil.transform((Iterable)items, (Function)new Function<JiraWebItemModuleDescriptor, Hint>(){

            public Hint get(JiraWebItemModuleDescriptor input) {
                if (input.getWebLabel() == null) {
                    log.warn((Object)("Hint web item with key '" + input.getKey() + "' does not define a label"));
                }
                return new HintImpl(DefaultHintManager.this.getText(input.getLabel(), user, helper), DefaultHintManager.this.getText(input.getTooltip(), user, helper));
            }
        });
    }

    private String getText(WebLabel input, User user, JiraHelper helper) {
        if (input == null) {
            return "";
        }
        return ((JiraWebLabel)input).getDisplayableLabel(user, helper);
    }
}

