/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.user.DelegatingUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.UserAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntityConditionFactory;
import com.atlassian.jira.crowd.embedded.ofbiz.db.DataAccessException;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizUserDao
implements UserDao {
    private final OfBizHelper ofBiz;
    private final DirectoryDao directoryDao;
    private final InternalMembershipDao membershipDao;
    private final ConcurrentMap<DirectoryEntityKey, OfBizUser> userCache = new ConcurrentHashMap<DirectoryEntityKey, OfBizUser>();
    private final ConcurrentMap<DirectoryEntityKey, Attributes> userAttributesCache = new ConcurrentHashMap<DirectoryEntityKey, Attributes>();
    private static final Function<GenericValue, String> TO_USERNAME_FUNCTION = new Function<GenericValue, String>(){

        public String apply(GenericValue gvUser) {
            return gvUser.getString("userName");
        }
    };
    private static final Function<GenericValue, OfBizUser> TO_USER_FUNCTION = new Function<GenericValue, OfBizUser>(){

        public OfBizUser apply(GenericValue gvUser) {
            return OfBizUser.from(gvUser);
        }
    };

    public OfBizUserDao(DelegatorInterface genericDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao) {
        this.ofBiz = new OfBizHelper(genericDelegator);
        this.directoryDao = directoryDao;
        this.membershipDao = membershipDao;
        this.buildCache();
    }

    public OfBizUser findByName(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = (OfBizUser)this.userCache.get(DirectoryEntityKey.getKeyPreserveCase(directoryId, userName));
        if (user != null) {
            return user;
        }
        user = (OfBizUser)this.userCache.get(DirectoryEntityKey.getKey(directoryId, userName));
        if (user == null) {
            throw new UserNotFoundException(userName);
        }
        return user;
    }

    public UserWithAttributes findByNameWithAttributes(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = this.findByName(directoryId, userName);
        Attributes attributes = (Attributes)this.userAttributesCache.get(DirectoryEntityKey.getKeyPreserveCase(directoryId, userName));
        if (attributes == null) {
            attributes = (Attributes)this.userAttributesCache.get(DirectoryEntityKey.getKey(directoryId, userName));
        }
        if (attributes == null) {
            List<GenericValue> attributesGenericValue = this.findAttributesGenericValues(directoryId, user.getId());
            attributes = OfBizAttributesBuilder.toAttributes(attributesGenericValue);
            this.userAttributesCache.put(DirectoryEntityKey.getKey(directoryId, userName), attributes);
        }
        return new DelegatingUserWithAttributes((User)user, attributes);
    }

    public PasswordCredential getCredential(long directoryId, String userName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(directoryId, userName);
        if (userGenericValue == null) {
            return null;
        }
        String storedCredential = userGenericValue.getString("credential");
        if (storedCredential == null) {
            return null;
        }
        return new PasswordCredential(storedCredential, true);
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String userName) throws UserNotFoundException {
        throw new UnsupportedOperationException("JIRA does not store User Credential History");
    }

    private GenericValue findUserGenericValue(long directoryId, String userName) throws UserNotFoundException {
        GenericValue userGenericValue = EntityUtil.getOnly(this.findUsers(PrimitiveMap.of("directoryId", directoryId, "lowerUserName", IdentifierUtils.toLowerCase((String)userName))));
        if (userGenericValue != null) {
            return userGenericValue;
        }
        throw new UserNotFoundException(userName);
    }

    private List<GenericValue> findUsers(Map<String, Object> filter) {
        return this.ofBiz.findByAnd("User", filter);
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        BatchResult results = new BatchResult(users.size());
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                User addedUser = this.add((User)user, user.getCredential());
                results.addSuccess((Object)addedUser);
            }
            catch (UserAlreadyExistsException e) {
                results.addFailure((Object)user);
            }
            catch (IllegalArgumentException e) {
                results.addFailure((Object)user);
            }
            catch (DataAccessException e) {
                results.addFailure((Object)user);
            }
        }
        return results;
    }

    public synchronized User add(User user, PasswordCredential credential) throws UserAlreadyExistsException {
        OfBizUser newUser;
        if (credential != null) {
            Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        }
        String userName = user.getName();
        GenericValue userGenericValue = EntityUtil.getOnly(this.findUsers(PrimitiveMap.of("directoryId", user.getDirectoryId(), "lowerUserName", IdentifierUtils.toLowerCase((String)user.getName()))));
        if (userGenericValue != null) {
            throw new UserAlreadyExistsException(user.getDirectoryId(), userName);
        }
        Timestamp currentTimestamp = this.getCurrentTimestamp();
        Map<String, Object> userData = UserEntity.getData(user, credential, currentTimestamp, currentTimestamp);
        this.ofBiz.createValue("User", userData);
        try {
            newUser = this.getUserFromDB(user.getDirectoryId(), userName);
        }
        catch (UserNotFoundException e) {
            throw new OperationFailedException("Created a new user '" + userName + "' - but was unable to retrieve them from the DB.", (Throwable)e);
        }
        this.putUserInCache(newUser);
        return newUser;
    }

    private Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private OfBizUser getUserFromDB(Long directoryId, String userName) throws UserNotFoundException {
        return OfBizUser.from(this.findUserGenericValue(directoryId, userName));
    }

    public void storeAttributes(User user, Map<String, Set<String>> attributes) throws UserNotFoundException {
        for (Map.Entry attribute : ((Map)Preconditions.checkNotNull(attributes)).entrySet()) {
            this.removeAttribute(user, (String)attribute.getKey());
            if (attribute.getValue() == null || ((Set)attribute.getValue()).isEmpty()) continue;
            this.storeAttributeValues(user, (String)attribute.getKey(), (Set)attribute.getValue());
        }
        this.userAttributesCache.remove(DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName()));
    }

    private void storeAttributeValues(User user, String name, Set<String> values) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        Long userId = userGenericValue.getLong("id");
        for (String value : values) {
            if (!StringUtils.isNotEmpty((String)value)) continue;
            this.storeAttributeValue(user.getDirectoryId(), userId, name, value);
        }
    }

    public void removeAllUsers(long directoryId, Set<String> userNames) {
        for (String userName : userNames) {
            try {
                this.remove((User)this.findByName(directoryId, userName));
            }
            catch (UserNotFoundException e) {}
        }
    }

    private void storeAttributeValue(Long directoryId, Long userId, String name, String value) throws UserNotFoundException {
        this.ofBiz.createValue("UserAttribute", UserAttributeEntity.getData(directoryId, userId, name, value));
    }

    private List<GenericValue> findAttributesGenericValues(Long directoryId, Long userId) {
        return this.ofBiz.findByAnd("UserAttribute", PrimitiveMap.of("directoryId", (long)directoryId, "userId", userId));
    }

    public synchronized User update(User user) throws UserNotFoundException {
        GenericValue userGenericValue = UserEntity.setData(user, this.findUserGenericValue(user.getDirectoryId(), user.getName()));
        userGenericValue.set("updatedDate", (Object)this.getCurrentTimestamp());
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        this.putUserInCache(newUser);
        return newUser;
    }

    public void updateCredential(User user, PasswordCredential credential, int credentialHistory) throws UserNotFoundException {
        Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        GenericValue storeGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        storeGenericValue.set("credential", (Object)credential.getCredential());
        this.storeUser(storeGenericValue);
    }

    private GenericValue storeUser(GenericValue userGenericValue) {
        this.ofBiz.store(userGenericValue);
        return userGenericValue;
    }

    public User rename(User user, String newName) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(User user, String attributeName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        this.ofBiz.removeByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userGenericValue.getLong("id"), "name", attributeName));
        this.userAttributesCache.remove(DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName()));
    }

    public synchronized void remove(User user) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        this.membershipDao.removeAllUserMemberships(user);
        this.ofBiz.removeByAnd("UserAttribute", PrimitiveMap.of("userId", userGenericValue.getLong("id")));
        this.ofBiz.removeValue(userGenericValue);
        this.userCache.remove(DirectoryEntityKey.getKey((DirectoryEntity)user));
        this.userAttributesCache.remove(DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName()));
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        UserQuery userQuery = (UserQuery)query;
        EntityCondition baseCondition = new UserEntityConditionFactory(this.ofBiz).getEntityConditionFor(userQuery.getSearchRestriction());
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        if (baseCondition == null) {
            return this.getAllUsersFromCache(directoryId, query.getReturnType());
        }
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        entityConditions.add(baseCondition);
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        List<GenericValue> results = this.ofBiz.findByCondition("User", (EntityCondition)entityCondition, null, Collections.singletonList("lowerUserName"));
        ArrayList<Object> typedResults = new ArrayList<Object>(results.size());
        Object valueFunction = query.getReturnType().equals(String.class) ? TO_USERNAME_FUNCTION : TO_USER_FUNCTION;
        for (GenericValue result : results) {
            typedResults.add(valueFunction.apply((Object)result));
        }
        return typedResults;
    }

    private <T> List<T> getAllUsersFromCache(long directoryId, Class<T> returnType) {
        ArrayList<OfBizUser> allUsers = new ArrayList<OfBizUser>();
        for (OfBizUser user : this.userCache.values()) {
            if (user.getDirectoryId() != directoryId) continue;
            allUsers.add(user);
        }
        if (returnType.isAssignableFrom(String.class)) {
            Function<OfBizUser, String> valueFunction = new Function<OfBizUser, String>(){

                public String apply(OfBizUser from) {
                    return from.getName();
                }
            };
            ArrayList<Object> typedResults = new ArrayList<Object>(allUsers.size());
            for (OfBizUser user : allUsers) {
                typedResults.add(valueFunction.apply((Object)user));
            }
            return typedResults;
        }
        if (returnType.isAssignableFrom(OfBizUser.class)) {
            return allUsers;
        }
        throw new IllegalArgumentException("Class type for return values ('" + returnType + "') is not 'String' or 'User'");
    }

    public synchronized void flushCache() {
        this.userAttributesCache.clear();
        this.userCache.clear();
        this.buildCache();
    }

    private void buildCache() {
        for (Directory directory : this.directoryDao.findAll()) {
            List<GenericValue> userGenericValues = this.findUsers(PrimitiveMap.of("directoryId", directory.getId()));
            for (GenericValue userGenericValue : userGenericValues) {
                this.putUserInCache((OfBizUser)TO_USER_FUNCTION.apply((Object)userGenericValue));
            }
        }
    }

    private void putUserInCache(OfBizUser user) {
        DirectoryEntityKey key = DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName());
        this.userCache.put(key, user);
    }
}

