/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.RemoteAddressEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

public class OfBizApplication
extends ApplicationImpl {
    private DirectoryDao directoryDao;
    private static final HashSet<OperationType> ALLOWED_OPERATIONS = Sets.newHashSet((Object[])OperationType.values());

    private OfBizApplication(GenericValue applicationGenericValue, List<GenericValue> remoteAddressGenericValue) {
        Preconditions.checkNotNull((Object)applicationGenericValue);
        this.id = applicationGenericValue.getLong("id");
        this.setName(applicationGenericValue.getString("name"));
        this.setCredential(new PasswordCredential(applicationGenericValue.getString("credential"), true));
        this.setType(ApplicationType.valueOf((String)applicationGenericValue.getString("applicationType")));
        this.active = BooleanUtils.toBoolean((int)applicationGenericValue.getInteger("active"));
        this.createdDate = OfBizHelper.convertToUtilDate(applicationGenericValue.getTimestamp("createdDate"));
        this.updatedDate = OfBizHelper.convertToUtilDate(applicationGenericValue.getTimestamp("updatedDate"));
        this.setDescription(applicationGenericValue.getString("description"));
        if (remoteAddressGenericValue != null) {
            this.setRemoteAddresses(RemoteAddressEntity.toRemoteAddresses(remoteAddressGenericValue));
        } else {
            this.setRemoteAddresses(Collections.emptySet());
        }
    }

    static OfBizApplication from(GenericValue genericValue, List<GenericValue> remoteAddressGenericValue) {
        return new OfBizApplication((GenericValue)Preconditions.checkNotNull((Object)genericValue), remoteAddressGenericValue);
    }

    public List<DirectoryMapping> getDirectoryMappings() {
        return Lists.transform((List)this.directoryDao.findAll(), (Function)new Function<Directory, DirectoryMapping>(){

            public DirectoryMapping apply(Directory directory) {
                return new DirectoryMapping((Application)OfBizApplication.this, directory, true, (Set)ALLOWED_OPERATIONS);
            }
        });
    }

    public DirectoryMapping getDirectoryMapping(long directoryId) {
        List<DirectoryMapping> directoryMappings = this.getDirectoryMappings();
        for (DirectoryMapping directoryMapping : directoryMappings) {
            if (!directoryMapping.getDirectory().getId().equals(directoryId)) continue;
            return directoryMapping;
        }
        return null;
    }

    void setDirectoryDao(OfBizDirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

