/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.gui;

import com.atlassian.jira.configurator.gui.LabelledComponent;
import com.atlassian.jira.configurator.gui.OptionalLabelledComponent;
import com.atlassian.jira.configurator.gui.VerticalFlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfigPanelBuilder {
    private final JPanel panel;
    private List<LabelledComponent> labelledComponents = new ArrayList<LabelledComponent>();

    public ConfigPanelBuilder() {
        this.panel = new JPanel(new VerticalFlowLayout());
    }

    public LabelledComponent add(String label, JComponent component) {
        LabelledComponent labelledComponent = new LabelledComponent(label, component);
        this.panel.add(labelledComponent);
        this.labelledComponents.add(labelledComponent);
        return labelledComponent;
    }

    public LabelledComponent add(String label, JComponent component, String defaultValue) {
        OptionalLabelledComponent labelledComponent = new OptionalLabelledComponent(label, component, defaultValue);
        this.panel.add(labelledComponent);
        this.labelledComponents.add(labelledComponent);
        return labelledComponent;
    }

    public JPanel getPanel() {
        this.setLabelWidths();
        return this.panel;
    }

    private void setLabelWidths() {
        int maxWidth = 0;
        for (LabelledComponent labelledComponent : this.labelledComponents) {
            int width = labelledComponent.getPreferredLabelWidth();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        for (LabelledComponent labelledComponent : this.labelledComponents) {
            labelledComponent.setLabelWidth(maxWidth);
        }
    }

    public void setTitle(String title) {
        this.panel.setBorder(new TitledBorder(title));
    }
}

