/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.config.FileExistanceWithCancelOptionValidator;
import com.atlassian.jira.configurator.config.FileSystem;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SslSettings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.config.Validator;
import com.atlassian.jira.configurator.console.ConsoleProvider;
import com.atlassian.jira.configurator.console.ConsoleToolkit;
import com.atlassian.jira.configurator.ssl.CertificateDetails;
import com.atlassian.jira.configurator.ssl.CertificatePrettyPrinter;
import com.atlassian.jira.configurator.ssl.KeyStoreAccessor;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class WebServerConfigurationConsole {
    private static final String DETAILS_URL = "https://confluence.atlassian.com/display/JIRA/Running+JIRA+over+SSL+or+HTTPS";
    private final ConsoleProvider console;
    private final ConsoleToolkit consoleToolkit;
    private final KeyStoreAccessor keyStoreAccessor;
    private final FileSystem fileSystem;
    private final Settings settings;

    public WebServerConfigurationConsole(@Nonnull ConsoleProvider console, @Nonnull KeyStoreAccessor keyStoreAccessor, @Nonnull FileSystem fileSystem, @Nonnull Settings settings) {
        this.console = console;
        this.consoleToolkit = new ConsoleToolkit(console);
        this.keyStoreAccessor = keyStoreAccessor;
        this.fileSystem = fileSystem;
        this.settings = settings;
    }

    public void showSettings() throws IOException {
        do {
            SslSettings sslSettings = this.settings.getSslSettings();
            this.console.println();
            this.console.println("--- Web Server Configuration ---");
            this.console.println("  Control Port  : " + StringUtils.defaultString((String)this.settings.getControlPort(), (String)"N/A"));
            this.console.println("  HTTP Port     : " + StringUtils.defaultString((String)this.settings.getHttpPort(), (String)"N/A"));
            this.console.println("  SSL Encryption: " + (sslSettings != null ? "enabled" : "disabled"));
            if (sslSettings != null) {
                this.console.println("  HTTPs Port    : " + sslSettings.getHttpsPort());
                this.console.println("  Keystore Path : " + sslSettings.getKeystoreFile());
                this.console.println("  Key Alias     : " + sslSettings.getKeyAlias());
            }
            this.console.println();
            this.consoleToolkit.showMenuItem('H', "Configure HTTP Port");
            if (sslSettings != null) {
                this.consoleToolkit.showMenuItem('D', "Disable SSL Encryption");
            }
            this.consoleToolkit.showMenuItem('S', "Configure SSL Encryption (requires an installed X509 certificate)");
            this.consoleToolkit.showMenuItem('X', "Return to Main Menu");
            this.console.println();
        } while (this.processWebServerSettings());
    }

    private boolean processWebServerSettings() throws IOException {
        char ch;
        block8: while (true) {
            ch = this.consoleToolkit.readMenuChoice("Web Server");
            switch (ch) {
                case '\n': 
                case '\r': {
                    continue block8;
                }
                case '?': {
                    return true;
                }
                case 'X': {
                    return false;
                }
                case 'H': {
                    this.showUpdateHttpConfiguration();
                    return true;
                }
                case 'D': {
                    this.disableSsl();
                    return true;
                }
                case 'S': {
                    this.showUpdateHttpsConfiguration();
                    return true;
                }
            }
            break;
        }
        this.console.println("Unknown command '" + ch + "'");
        return true;
    }

    private void disableSsl() {
        this.settings.setSslSettings(null);
        this.console.println();
        this.console.println("SSL encryption disabled. Remember to save the changes on exit.");
    }

    private void showUpdateHttpConfiguration() throws IOException {
        int newHttpPort;
        int controlPort = Integer.parseInt(this.settings.getControlPort());
        SslSettings sslSettings = this.settings.getSslSettings();
        Integer httpsPort = sslSettings != null && sslSettings.getHttpsPort() != null ? Integer.valueOf(Integer.parseInt(sslSettings.getHttpsPort())) : null;
        while (true) {
            this.console.println();
            this.console.println("You can update the HTTP port to a new value. The current port is: " + this.settings.getHttpPort());
            newHttpPort = this.askFor("HTTP Port", Validator.PORT);
            if (newHttpPort == controlPort) {
                this.console.printErrorMessage("The entered port is already used by the control port. Please pick a different port.");
                continue;
            }
            if (httpsPort == null || newHttpPort != httpsPort) break;
            this.console.printErrorMessage("The entered port is already used by the HTTPs port. Please pick a different port.");
        }
        this.settings.setHttpPort(Integer.toString(newHttpPort));
        this.console.println();
        this.console.println("Updated the HTTP port to " + newHttpPort + ". Remember to save the changes on exit.");
    }

    private void showUpdateHttpsConfiguration() throws IOException {
        this.console.println();
        this.console.println("The next steps gather all required information to set up the HTTPs port (HTTP over SSL encryption). First of all, you need provide a so called key store containing the private key and the signed certificate. This can be either self-signed or obtained from a certified authority (CA). For more information, please see the link below. In order to verify the entered information, this tool will access the key store and print the certificate found.");
        this.console.println();
        this.console.println(DETAILS_URL);
        CertificateDetails certificateDetails = this.askForKeyStoreDetailsOrCancel();
        if (certificateDetails == null) {
            return;
        }
        int httpsPort = this.askFor("HTTPs Port", Validator.PORT);
        SslSettings newSslSettings = new SslSettings(Integer.toString(httpsPort), certificateDetails.getKeyStoreLocation(), certificateDetails.getKeyStorePassword(), "JKS", certificateDetails.getKeyAlias());
        this.settings.setSslSettings(newSslSettings);
        this.console.println();
        this.console.println("Updated the SSL encryption settings. Remember to save the changes on exit.");
    }

    private CertificateDetails askForKeyStoreDetailsOrCancel() throws IOException {
        while (true) {
            String alias;
            String keystoreLocation;
            if ((keystoreLocation = this.askForKeyStoreLocationOrCancel()) == null) {
                return null;
            }
            String keyStorePassword = this.askForPassword("Keystore Password", Validator.NON_EMTPY_STRING);
            CertificateDetails certificateDetails = new CertificateDetails(keystoreLocation, keyStorePassword, alias = this.askFor("Key Alias", Validator.NON_EMTPY_STRING));
            X509Certificate x509Certificate = this.loadCertificate(certificateDetails);
            if (x509Certificate != null) {
                this.console.println();
                this.console.println("The following certificate was found:");
                this.console.println();
                this.console.println(CertificatePrettyPrinter.prettyPrint(x509Certificate));
                boolean correctCertificate = this.console.readYesNo("Do you want to use this certificate?", Boolean.TRUE);
                if (!correctCertificate) continue;
                return certificateDetails;
            }
            boolean tryAgain = this.console.readYesNo("The referenced certificate could not be found or accessed. Do you want to try again?", Boolean.TRUE);
            if (!tryAgain) break;
        }
        return null;
    }

    private String askForKeyStoreLocationOrCancel() throws IOException {
        File caCertsPath = this.getCaCertsPath();
        String canonicalCaCertsPath = caCertsPath.getCanonicalPath();
        SslSettings sslSettings = this.settings.getSslSettings();
        block6: while (true) {
            this.console.println();
            this.console.println("Please select the keystore from the options below. It must contain the certificate and the private key to be used.");
            this.consoleToolkit.showMenuItem('S', String.format("The system-wide Java keystore (%s)", canonicalCaCertsPath));
            this.consoleToolkit.showMenuItem('U', "User-defined location");
            if (sslSettings != null) {
                this.consoleToolkit.showMenuItem('C', String.format("The currently configured (%s)", sslSettings.getKeystoreFile()));
            }
            char keystore = this.consoleToolkit.readMenuChoice("Keystore");
            switch (keystore) {
                case '\n': 
                case '\r': {
                    continue block6;
                }
                case 'S': {
                    return canonicalCaCertsPath;
                }
                case 'U': {
                    return this.askForUserDefinedKeyStorePathOrCancel();
                }
                case 'C': {
                    if (sslSettings == null) break;
                    return sslSettings.getKeystoreFile();
                }
            }
            this.console.println("Unknown command '" + keystore + "'");
        }
    }

    private File getCaCertsPath() {
        String javaHome = System.getProperty("java.home");
        String caCertsPathAsText = Joiner.on((char)File.separatorChar).join((Iterable)Lists.newArrayList((Object[])new String[]{javaHome, "lib", "security", "cacerts"}));
        return new File(caCertsPathAsText);
    }

    @Nullable
    public X509Certificate loadCertificate(@Nonnull CertificateDetails certificateDetails) {
        try {
            return this.keyStoreAccessor.loadCertificate(certificateDetails);
        }
        catch (UnrecoverableEntryException e) {
            this.console.printErrorMessage("The entered password is valid for the key store, but not for the private key. You need to synchronize both passwords in order to proceed.");
            return null;
        }
        catch (Exception e) {
            this.console.printErrorMessage(e);
            return null;
        }
    }

    private String askForUserDefinedKeyStorePathOrCancel() throws IOException {
        FileExistanceWithCancelOptionValidator validator = new FileExistanceWithCancelOptionValidator(this.fileSystem);
        while (true) {
            try {
                return (String)((Validator)validator).apply("Keystore Path", this.console.readLine("Keystore Path (leave blank to exit)"));
            }
            catch (ValidationException e) {
                this.console.printErrorMessage(e);
                continue;
            }
            break;
        }
    }

    private <T> T askFor(@Nonnull String label, @Nonnull Validator<T> validator) throws IOException {
        while (true) {
            try {
                return validator.apply(label, this.console.readLine(label));
            }
            catch (ValidationException e) {
                this.console.printErrorMessage(e);
                continue;
            }
            break;
        }
    }

    private <T> T askForPassword(@Nonnull String label, @Nonnull Validator<T> validator) throws IOException {
        while (true) {
            try {
                return validator.apply(label, this.console.readPassword(label));
            }
            catch (ValidationException e) {
                this.console.printErrorMessage(e);
                continue;
            }
            break;
        }
    }
}

