/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.configurator.console.ConsoleProvider;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ConsoleToolkit {
    private final ConsoleProvider console;

    public ConsoleToolkit(@Nonnull ConsoleProvider console) {
        this.console = console;
    }

    public String menuItemAndValue(String label, Object value) {
        StringBuilder sb = new StringBuilder(128).append(label);
        while (sb.length() < 40) {
            sb.append(' ');
        }
        sb.append(": ");
        if (value != null) {
            sb.append(value);
        } else {
            sb.append("(default)");
        }
        return value != null ? label + " (" + value + ")" : label;
    }

    public void showMenuItem(char key, String label) {
        this.console.println("  [" + key + "] " + label);
    }

    public void showDefaultMenuItem(char key, String label) {
        this.console.println("* [" + key + "] " + label);
    }

    public void showMenuItem(char key, String label, char defaultKey) {
        if (key == defaultKey) {
            this.showDefaultMenuItem(key, label);
        } else {
            this.showMenuItem(key, label);
        }
    }

    public char readMenuChoice(String menuName) throws IOException {
        return Character.toUpperCase(this.console.readFirstChar(menuName));
    }
}

