/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.JndiDatasource;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.JiraHomeDatabaseConfigurationLoader;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SslSettings;
import com.atlassian.jira.exception.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingsLoader {
    private static final String DEV_MODE_SERVER_XML = "tomcatBase/tomcat6/conf/server.xml";
    private static final String DEV_MODE_DEFAULT_KEY_STORE = "tomcatBase/tomcat6/conf/jira.ks";
    private static final boolean devMode = new File("tomcatBase/tomcat6/conf/server.xml").exists();

    public static Settings loadCurrentSettings() throws ParserConfigurationException, IOException, SAXException, ParseException {
        Settings settings = new Settings();
        SettingsLoader.loadApplicationProperties(settings);
        SettingsLoader.loadDbConfig(settings);
        SettingsLoader.loadServerXmlSettings(settings);
        return settings;
    }

    public static void saveSettings(Settings newSettings) throws IOException {
        SettingsLoader.saveSettingsToApplicationProperties(newSettings);
        SettingsLoader.saveSettingsToServerXml(newSettings);
        SettingsLoader.saveDbConfig(newSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSettingsToApplicationProperties(Settings newSettings) throws IOException {
        if (newSettings.getJiraHome() == null || newSettings.getJiraHome().trim().length() == 0) {
            throw new IOException("Please set a value for jira-home.");
        }
        File jiraHomeDirectory = new File(newSettings.getJiraHome());
        if (jiraHomeDirectory.exists()) {
            if (!jiraHomeDirectory.isDirectory()) {
                throw new IOException("jira-home '" + newSettings.getJiraHome() + "' is not a directory.");
            }
        } else {
            boolean created = jiraHomeDirectory.mkdirs();
            if (!created) {
                throw new IOException("Unable to create jira-home '" + newSettings.getJiraHome() + "'");
            }
        }
        BufferedReader reader = new BufferedReader(new FileReader(SettingsLoader.getJiraApplicationProperties()));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean jiraHomeSet = false;
            while ((line = reader.readLine()) != null) {
                if (SettingsLoader.isJiraHomeProperty(line)) {
                    sb.append("jira.home = ").append(SettingsLoader.encodeForPropertiesFile(newSettings.getJiraHome())).append("\n");
                    jiraHomeSet = true;
                    continue;
                }
                sb.append(line).append("\n");
            }
            if (!jiraHomeSet) {
                throw new IOException("Unable to find the jira.home property to replace in the jira.application.properties file (" + SettingsLoader.getJiraApplicationProperties() + ").");
            }
        }
        finally {
            reader.close();
        }
        FileWriter writer = new FileWriter(SettingsLoader.getJiraApplicationProperties());
        try {
            writer.write(sb.toString());
        }
        finally {
            writer.close();
        }
    }

    private static String encodeForPropertiesFile(String value) {
        return value.replace("\\", "\\\\");
    }

    private static boolean isJiraHomeProperty(String line) {
        if (line.startsWith("jira.home")) {
            String value = line.substring("jira.home".length());
            if ((value = value.trim()).startsWith("=")) {
                return true;
            }
        }
        return false;
    }

    private static void saveSettingsToServerXml(Settings newSettings) throws IOException {
        Document doc;
        try {
            doc = SettingsLoader.parseDocument(SettingsLoader.getServerXmlFile());
            SettingsLoader.saveNetworkingSettingsToServerXml(newSettings, doc);
        }
        catch (Exception ex) {
            String message = "An error occured while trying to save settings. Your settings may be in an invalid state.";
            if (ex.getMessage() != null) {
                message = message + " " + ex.getMessage();
            }
            throw new IOException(message);
        }
        SettingsLoader.writeXmlFile(doc, SettingsLoader.getServerXmlFile());
    }

    static void saveNetworkingSettingsToServerXml(Settings newSettings, Document doc) throws ParseException {
        Node serverNode = SettingsLoader.getOnlyChildNode(doc, "Server");
        SettingsLoader.addAttributeToNode(doc, serverNode, "port", newSettings.getControlPort());
        Node serviceNode = SettingsLoader.getOnlyChildNode(serverNode, "Service");
        Node httpConnectorNode = SettingsLoader.getChildNodeWithAttribute(serviceNode, "Connector", "protocol", "HTTP/1.1");
        SettingsLoader.addAttributeToNode(doc, httpConnectorNode, "port", newSettings.getHttpPort());
        SslSettings sslSettings = newSettings.getSslSettings();
        Node httpsConnectorNode = SettingsLoader.getChildNodeWithAttribute(serviceNode, "Connector", "secure", "true");
        if (sslSettings != null) {
            if (httpsConnectorNode == null) {
                httpsConnectorNode = serviceNode.appendChild(doc.createElement("Connector"));
            }
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "port", sslSettings.getHttpsPort());
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "scheme", "https");
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "secure", "true");
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "keystoreFile", sslSettings.getKeystoreFile());
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "keystorePass", sslSettings.getKeystorePass());
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "keystoreType", sslSettings.getKeystoreType());
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "keyAlias", sslSettings.getKeyAlias());
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "clientAuth", "false");
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "sslProtocol", "TLS");
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "SSLEnabled", "true");
            SettingsLoader.addAttributeToNode(doc, httpsConnectorNode, "protocol", "org.apache.coyote.http11.Http11Protocol");
            SettingsLoader.addDefaultConnectorDefaultSettings(httpsConnectorNode);
        } else if (httpsConnectorNode != null) {
            serviceNode.removeChild(httpsConnectorNode);
        }
    }

    private static void addDefaultConnectorDefaultSettings(@Nonnull Node httpsConnectorNode) {
        SettingsLoader.updateAttribute(httpsConnectorNode, "maxThreads", "150");
        SettingsLoader.updateAttribute(httpsConnectorNode, "minSpareThreads", "25");
        SettingsLoader.updateAttribute(httpsConnectorNode, "maxSpareThreads", "75");
        SettingsLoader.updateAttribute(httpsConnectorNode, "connectionTimeout", "20000");
        SettingsLoader.updateAttribute(httpsConnectorNode, "enableLookups", "false");
        SettingsLoader.updateAttribute(httpsConnectorNode, "maxHttpHeaderSize", "8192");
        SettingsLoader.updateAttribute(httpsConnectorNode, "useBodyEncodingForURI", "true");
        SettingsLoader.updateAttribute(httpsConnectorNode, "acceptCount", "100");
        SettingsLoader.updateAttribute(httpsConnectorNode, "disableUploadTimeout", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDbConfig(Settings newSettings) {
        JiraHomeDatabaseConfigurationLoader databaseConfigurationLoader = new JiraHomeDatabaseConfigurationLoader(newSettings.getJiraHome());
        DatabaseType databaseType = newSettings.initDatabaseType(false);
        newSettings.applyDefaultAdvancedSettings();
        ConnectionPoolInfo connectionPoolInfo = newSettings.getConnectionPoolInfoBuilder().build();
        JdbcDatasource.Builder datasourceBuilder = newSettings.getJdbcDatasourceBuilder();
        try {
            JdbcDatasource datasource = datasourceBuilder.setConnectionPoolInfo(connectionPoolInfo).build();
            DatabaseConfig databaseConfig = new DatabaseConfig(databaseType.getTypeName(), newSettings.getSchemaName(), datasource);
            databaseConfigurationLoader.saveDatabaseConfiguration(databaseConfig);
        }
        finally {
            datasourceBuilder.setConnectionPoolInfo(null);
        }
    }

    private static void writeXmlFile(Document doc, String filename) throws IOException {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(filename);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception ex) {
            String errorMessage = "An error occurred while writing XML file '" + filename + "'.";
            System.err.println(errorMessage);
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            throw new IOException(errorMessage + "\n" + ex.getMessage());
        }
    }

    private static Document parseDocument(String filename) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(filename);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Error occurred trying to parse the XML file '" + filename + "'. " + ex.getMessage());
        }
        catch (SAXException ex) {
            throw new IOException("Error occurred trying to parse the XML file '" + filename + "'. " + ex.getMessage());
        }
    }

    private static IOException asIOException(RuntimeException re) {
        Throwable cause = re.getCause();
        if (cause == null) {
            cause = re;
        } else if (cause instanceof IOException) {
            return (IOException)cause;
        }
        IOException ioe = new IOException("Unable to load database configuration: " + cause);
        ioe.initCause(cause);
        return ioe;
    }

    private static void loadDbConfig(Settings settings) throws IOException {
        DatabaseConfig databaseConfig;
        String jiraHome = settings.getJiraHome();
        if (jiraHome == null || jiraHome.length() == 0) {
            System.out.println("jira-home not configured - no database settings can be loaded.");
            return;
        }
        File dbConfigFile = new File(settings.getJiraHome(), "dbconfig.xml");
        if (!dbConfigFile.exists()) {
            System.out.println("DB config file '" + dbConfigFile.getAbsolutePath() + "' is not created yet - loading database settings as blank.");
            return;
        }
        try {
            databaseConfig = new JiraHomeDatabaseConfigurationLoader(jiraHome).loadDatabaseConfiguration();
        }
        catch (RuntimeException re) {
            throw SettingsLoader.asIOException(re);
        }
        SettingsLoader.loadDbConfig(databaseConfig, settings);
    }

    private static void loadDbConfig(DatabaseConfig databaseConfig, Settings settings) throws IOException {
        Datasource datasource = databaseConfig.getDatasource();
        if (datasource instanceof JndiDatasource) {
            throw new IOException("You current database configuration uses JNDI, and this configuration tool does not support that");
        }
        if (!(datasource instanceof JdbcDatasource)) {
            throw new IOException("Unrecognized datasource configuration " + datasource);
        }
        JdbcDatasource jdbcDatasource = (JdbcDatasource)datasource;
        settings.setSchemaName(databaseConfig.getSchemaName());
        settings.setJdbcDatasourceBuilder(jdbcDatasource.toBuilder().setConnectionPoolInfo(null));
        settings.setConnectionPoolInfoBuilder(jdbcDatasource.getConnectionPoolInfo().toBuilder());
        try {
            settings.initDatabaseType(true);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
    }

    private static void loadServerXmlSettings(Settings settings) throws IOException {
        Document doc = SettingsLoader.parseDocument(SettingsLoader.getServerXmlFile());
        try {
            SettingsLoader.loadWebServerSettings(doc, settings);
        }
        catch (ParseException ex) {
            throw new IOException("Unable to parse the config file '" + SettingsLoader.getServerXmlFile() + "'. " + ex.getMessage());
        }
    }

    static void loadWebServerSettings(Document doc, Settings settings) throws ParseException {
        Node serverNode = SettingsLoader.getOnlyChildNode(doc, "Server");
        settings.setControlPort(SettingsLoader.getAttributeValue(serverNode, "port"));
        Node childNode = SettingsLoader.getOnlyChildNode(serverNode, "Service");
        Node httpConnectorNode = SettingsLoader.getChildNodeWithAttribute(childNode, "Connector", "protocol", "HTTP/1.1");
        settings.setHttpPort(SettingsLoader.getAttributeValue(httpConnectorNode, "port"));
        Node sslConnectorNode = SettingsLoader.getChildNodeWithAttribute(childNode, "Connector", "secure", "true");
        settings.setSslSettings(SettingsLoader.parseSslSettings(sslConnectorNode));
    }

    @Nullable
    private static SslSettings parseSslSettings(@Nullable Node sslConnectorNode) {
        if (sslConnectorNode == null) {
            return null;
        }
        String port = SettingsLoader.getAttributeValue(sslConnectorNode, "port");
        String keystoreFile = SettingsLoader.getAttributeValue(sslConnectorNode, "keystoreFile");
        String keystorePass = SettingsLoader.getAttributeValue(sslConnectorNode, "keystorePass");
        String keystoreType = StringUtils.defaultString((String)SettingsLoader.getAttributeValue(sslConnectorNode, "keystoreType"), (String)"JKS");
        String keyAlias = SettingsLoader.getAttributeValue(sslConnectorNode, "keyAlias");
        return new SslSettings(port, keystoreFile, keystorePass, keystoreType, keyAlias);
    }

    private static void loadApplicationProperties(Settings settings) throws IOException {
        File jiraApplicationProperties = new File(SettingsLoader.getJiraApplicationProperties());
        SettingsLoader.logInfo("Loading application properties from " + jiraApplicationProperties.getCanonicalPath());
        FileInputStream propertiesInputStream = new FileInputStream(jiraApplicationProperties);
        try {
            String jiraHome = SettingsLoader.getJiraHomeValue(propertiesInputStream);
            if (File.separatorChar == '\\') {
                jiraHome = jiraHome.replace("/", "\\");
            }
            settings.setJiraHome(jiraHome);
        }
        catch (ParseException ex) {
            throw new IOException("Error parsing " + jiraApplicationProperties + ". " + ex.getMessage());
        }
        finally {
            ((InputStream)propertiesInputStream).close();
        }
    }

    private static void logInfo(String message) {
        System.out.println(message);
    }

    static String getJiraHomeValue(InputStream propertiesInputStream) throws ParseException, IOException {
        Properties applicationProperties = new Properties();
        applicationProperties.load(propertiesInputStream);
        String jiraHome = applicationProperties.getProperty("jira.home");
        if (jiraHome == null) {
            throw new ParseException("Unable to find the jira.home property.");
        }
        return jiraHome;
    }

    private static Node getChildNodeWithAttribute(Node parentNode, String tagName, String attributeName, String attributeValue) {
        List<Node> nodes = SettingsLoader.getChildNodes(parentNode, tagName);
        for (Node node : nodes) {
            String value = SettingsLoader.getAttributeValue(node, attributeName);
            if (!attributeValue.equals(value)) continue;
            return node;
        }
        return null;
    }

    private static String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attrNode = attributes.getNamedItem(attributeName);
        if (attrNode == null) {
            return null;
        }
        return attrNode.getNodeValue();
    }

    private static Node getOnlyChildNode(Node parentNode, String tagName) throws ParseException {
        List<Node> childNodes = SettingsLoader.getChildNodes(parentNode, tagName);
        if (childNodes.size() == 1) {
            return childNodes.get(0);
        }
        if (childNodes.size() == 0) {
            return null;
        }
        throw new ParseException("Expected to find one child <" + tagName + "> in <" + parentNode.getNodeName() + "> but found " + childNodes.size());
    }

    private static List<Node> getChildNodes(Node parentNode, String tagName) {
        NodeList childNodes = parentNode.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(tagName)) continue;
            list.add(child);
        }
        return list;
    }

    private static void addAttributeToNode(@Nonnull Document doc, @Nonnull Node targetNode, @Nonnull String attributeName, @Nonnull String attributeValue) {
        Attr attribute = doc.createAttribute(attributeName);
        attribute.setNodeValue(attributeValue);
        NamedNodeMap nodeAttributes = targetNode.getAttributes();
        nodeAttributes.setNamedItem(attribute);
    }

    private static void updateAttribute(@Nonnull Node targetNode, @Nonnull String attributeName, @Nonnull String attributeValue) {
        NamedNodeMap nodeAttributes = targetNode.getAttributes();
        if (nodeAttributes.getNamedItem(attributeName) == null) {
            Document doc = targetNode.getOwnerDocument();
            Attr attribute = doc.createAttribute(attributeName);
            attribute.setNodeValue(attributeValue);
            nodeAttributes.setNamedItem(attribute);
        }
    }

    private static String getServerXmlFile() {
        if (devMode) {
            return DEV_MODE_SERVER_XML;
        }
        return "../conf/server.xml";
    }

    private static String getJiraApplicationProperties() {
        if (devMode) {
            return "jira-components/jira-core/src/main/resources/jira-application.properties";
        }
        return "../atlassian-jira/WEB-INF/classes/jira-application.properties";
    }

    public static String getDefaultKeyStoreFile() {
        if (devMode) {
            return DEV_MODE_DEFAULT_KEY_STORE;
        }
        return "../conf/jira.ks";
    }

    public static Settings reloadDbConfig(String jiraHome) throws IOException {
        Settings settings = new Settings();
        settings.setJiraHome(jiraHome);
        SettingsLoader.loadDbConfig(settings);
        return settings;
    }
}

