/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.jira.config.database.DatabaseConfigHandler;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.ToStringBuilderExcludingPassword;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfig;
import com.atlassian.jira.configurator.db.DatabaseConfigFactory;
import com.atlassian.jira.util.KeyValuePair;
import com.atlassian.jira.util.KeyValueParser;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;

public final class JdbcDatasource
implements Datasource {
    private static final Logger log = Logger.getLogger(DatabaseConfigHandler.class);
    static final String JDBC_DATASOURCE = "jdbc-datasource";
    private static final String URL = "url";
    private static final String DRIVER_CLASS = "driver-class";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CONNECTION_PROPERTIES = "connection-properties";
    private static final String POOL_SIZE = "pool-size";
    private static final String POOL_MAX_SIZE = "pool-max-size";
    private static final String POOL_MIN_SIZE = "pool-min-size";
    private static final String POOL_MAX_WAIT = "pool-max-wait";
    private static final String POOL_SLEEP_TIME = "pool-sleep-time";
    private static final String POOL_LIFE_TIME = "pool-life-time";
    private static final String DEADLOCK_MAX_WAIT = "deadlock-max-wait";
    private static final String DEADLOCK_RETRY_WAIT = "deadlock-retry-wait";
    private static final String VALIDATION_QUERY = "validation-query";
    private static final String MIN_EVICTABLE_IDLE_TIME_MILLIS = "min-evictable-idle-time-millis";
    private static final String TIME_BETWEEN_EVICTION_RUNS_MILLIS = "time-between-eviction-runs-millis";
    private static final String DEFAULT_CATALOG = "default-catalog";
    private static final String MAX_OPEN_PREPARED_STATEMENTS = "max-open-prepared-statements";
    private static final String POOL_INITIAL_SIZE = "pool-initial-size";
    private static final String POOL_MAX_IDLE = "pool-max-idle";
    private static final String POOL_NUM_TESTS_PER_EVICTION_RUN = "pool-num-tests-per-eviction-run";
    private static final String POOL_PREPARED_STATEMENTS = "pool-prepared-statements";
    private static final String POOL_REMOVE_ABANDONED = "pool-remove-abandoned";
    private static final String POOL_REMOVE_ABANDONED_TIMEOUT = "pool-remove-abandoned-timeout";
    private static final String POOL_TEST_ON_BORROW = "pool-test-on-borrow";
    private static final String POOL_TEST_ON_RETURN = "pool-test-on-return";
    private static final String POOL_TEST_WHILE_IDLE = "pool-test-while-idle";
    private static final String VALIDATION_QUERY_TIMEOUT = "validation-query-timeout";
    private final String jdbcUrl;
    private final String driverClassName;
    private final String username;
    private final String password;
    private final Properties connectionProperties;
    private final ConnectionPoolInfo poolInfo;
    private static boolean registerDriverOnConstruct = true;

    public static void setRegisterDriverOnConstruct(boolean registerDriverOnConstruct) {
        JdbcDatasource.registerDriverOnConstruct = registerDriverOnConstruct;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public JdbcDatasource(String jdbcUrl, String driverClassName, String username, String password, int poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(JdbcDatasource.builder(username, password, poolMaxSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis).setJdbcUrl(jdbcUrl).setDriverClassName(driverClassName));
    }

    @Deprecated
    public JdbcDatasource(String jdbcUrl, String driverClassName, String username, String password, Properties connectionProperties, int poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(JdbcDatasource.builder(username, password, poolMaxSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis).setJdbcUrl(jdbcUrl).setDriverClassName(driverClassName).setConnectionProperties(connectionProperties));
    }

    @Deprecated
    public JdbcDatasource(DatabaseType databaseType, String hostname, String port, String instance, String username, String password, Integer poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(JdbcDatasource.builder(username, password, poolMaxSize, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis).setDatabaseType(databaseType).setHostname(hostname).setPort(port).setInstance(instance));
    }

    public JdbcDatasource(JdbcDatasourceInfo jdbc) {
        this(JdbcDatasource.builder().setJdbcUrl(jdbc.getUri()).setDriverClassName(jdbc.getDriverClassName()).setUsername(jdbc.getUsername()).setPassword(jdbc.getPassword()).setConnectionProperties(jdbc.getConnectionProperties()).setConnectionPoolInfo(jdbc.getConnectionPoolInfo()));
    }

    private JdbcDatasource(Builder builder) {
        DatabaseType databaseType = builder.getDatabaseType();
        if (builder.getJdbcUrl() == null) {
            if (databaseType == null) {
                throw new IllegalArgumentException("Must set either the JDBC URL or the database type");
            }
            DatabaseConfig databaseConfig = DatabaseConfigFactory.getDatabaseConfigFor(databaseType);
            try {
                this.jdbcUrl = databaseConfig.getUrl(builder.getHostname(), builder.getPort(), builder.getInstance());
                this.driverClassName = databaseConfig.getClassName();
            }
            catch (ValidationException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            this.jdbcUrl = builder.getJdbcUrl();
            this.driverClassName = builder.getDriverClassName();
        }
        Assertions.notBlank((String)"JDBC URL", (String)this.jdbcUrl);
        Assertions.notBlank((String)"JDBC Driver Class Name", (String)this.driverClassName);
        this.username = Assertions.notBlank((String)USERNAME, (String)builder.getUsername());
        this.password = (String)Assertions.notNull((String)PASSWORD, (Object)builder.getPassword());
        Properties properties = builder.getConnectionProperties();
        this.connectionProperties = properties != null ? (Properties)properties.clone() : null;
        this.poolInfo = (ConnectionPoolInfo)Assertions.notNull((String)"connectionPoolInfo", (Object)builder.getConnectionPoolInfo());
        Assertions.not((String)"poolInfo.getMaxSize() <= 0", (this.poolInfo.getMaxSize() <= 0 ? 1 : 0) != 0);
        if (registerDriverOnConstruct) {
            this.registerDriver();
        }
    }

    private static Builder builder(String username, String password, Integer poolMaxSize, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        ConnectionPoolInfo connectionPoolInfo = ConnectionPoolInfo.builder().setPoolMaxSize(poolMaxSize).setValidationQuery(validationQuery).setMinEvictableTimeMillis(minEvictableTimeMillis).setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis).build();
        return new Builder().setUsername(username).setPassword(password).setConnectionPoolInfo(connectionPoolInfo);
    }

    public Builder toBuilder() {
        return new Builder().setJdbcUrl(this.jdbcUrl).setDriverClassName(this.driverClassName).setUsername(this.username).setPassword(this.password).setConnectionPoolInfo(this.poolInfo);
    }

    private void registerDriver() {
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("JDBC Driver class '" + this.driverClassName + " could not be loaded.'", ex);
        }
    }

    @Override
    public Connection getConnection(AtlassianBootstrapManager bootstrapManager) throws BootstrapException {
        return bootstrapManager.getTestDatabaseConnection(this.createDbDetails());
    }

    @Override
    public DatasourceInfo getDatasource(String datasourceName, String databaseType, String schemaName) {
        JdbcDatasourceInfo jdbcInfo = new JdbcDatasourceInfo(this.jdbcUrl, this.driverClassName, this.username, this.password, null, this.connectionProperties, this.poolInfo);
        return new DatasourceInfo(datasourceName, databaseType, schemaName, jdbcInfo);
    }

    @Override
    public String getDescriptorValue(String databaseType) {
        return databaseType + " " + this.jdbcUrl;
    }

    @Override
    public String getDescriptorLabel() {
        return "Database JDBC config";
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties != null ? (Properties)this.connectionProperties.clone() : null;
    }

    public ConnectionPoolInfo getConnectionPoolInfo() {
        return this.poolInfo;
    }

    @Deprecated
    public int getPoolSize() {
        return this.poolInfo.getMaxSize();
    }

    @Deprecated
    public String getValidationQuery() {
        return this.poolInfo.getValidationQuery();
    }

    @Deprecated
    public Long getMinEvictableTimeMillis() {
        return this.poolInfo.getMinEvictableTimeMillis();
    }

    @Deprecated
    public Long getTimeBetweenEvictionRunsMillis() {
        return this.poolInfo.getTimeBetweenEvictionRunsMillis();
    }

    public String toString() {
        return ToStringBuilderExcludingPassword.toString(this);
    }

    public boolean equals(Object o) {
        return o instanceof JdbcDatasource && this.toBuilder().equals(((JdbcDatasource)o).toBuilder());
    }

    public int hashCode() {
        return this.toBuilder().hashCode();
    }

    DatabaseDetails createDbDetails() {
        DatabaseDetails dbDetails = new DatabaseDetails();
        dbDetails.setDatabaseUrl(this.jdbcUrl);
        dbDetails.setDriverClassName(this.driverClassName);
        dbDetails.setUserName(this.username);
        dbDetails.setPassword(this.password);
        dbDetails.setPoolSize(this.poolInfo.getMaxSize());
        return dbDetails;
    }

    static JdbcDatasource parse(Element datasourceElement) {
        if (datasourceElement == null || !datasourceElement.getName().equals(JDBC_DATASOURCE)) {
            throw new IllegalArgumentException("Expected jdbc-datasource element");
        }
        Properties connectionProperties = JdbcDatasource.parseConnectionProperties(datasourceElement.elementText(CONNECTION_PROPERTIES));
        Integer poolMaxSize = JdbcDatasource.parseInteger(datasourceElement, POOL_MAX_SIZE);
        if (poolMaxSize == null) {
            poolMaxSize = JdbcDatasource.parseInteger(datasourceElement, POOL_SIZE);
        }
        ConnectionPoolInfo poolInfo = ConnectionPoolInfo.builder().setPoolMaxSize(poolMaxSize).setPoolMinSize(JdbcDatasource.parseInteger(datasourceElement, POOL_MIN_SIZE)).setPoolMaxWait(JdbcDatasource.parseLong(datasourceElement, POOL_MAX_WAIT)).setPoolSleepTime(JdbcDatasource.parseLong(datasourceElement, POOL_SLEEP_TIME)).setPoolLifeTime(JdbcDatasource.parseLong(datasourceElement, POOL_LIFE_TIME)).setDeadLockMaxWait(JdbcDatasource.parseLong(datasourceElement, DEADLOCK_MAX_WAIT)).setDeadLockRetryWait(JdbcDatasource.parseLong(datasourceElement, DEADLOCK_RETRY_WAIT)).setValidationQuery(datasourceElement.elementText(VALIDATION_QUERY)).setMinEvictableTimeMillis(JdbcDatasource.parseLong(datasourceElement, MIN_EVICTABLE_IDLE_TIME_MILLIS)).setTimeBetweenEvictionRunsMillis(JdbcDatasource.parseLong(datasourceElement, TIME_BETWEEN_EVICTION_RUNS_MILLIS)).setDefaultCatalog(datasourceElement.elementText(DEFAULT_CATALOG)).setMaxOpenPreparedStatements(JdbcDatasource.parseInteger(datasourceElement, MAX_OPEN_PREPARED_STATEMENTS)).setNumTestsPerEvictionRun(JdbcDatasource.parseInteger(datasourceElement, POOL_NUM_TESTS_PER_EVICTION_RUN)).setPoolInitialSize(JdbcDatasource.parseInteger(datasourceElement, POOL_INITIAL_SIZE)).setPoolMaxIdle(JdbcDatasource.parseInteger(datasourceElement, POOL_MAX_IDLE)).setPoolPreparedStatements(JdbcDatasource.parseBoolean(datasourceElement, POOL_PREPARED_STATEMENTS)).setRemoveAbandoned(JdbcDatasource.parseBoolean(datasourceElement, POOL_REMOVE_ABANDONED)).setRemoveAbandonedTimeout(JdbcDatasource.parseInteger(datasourceElement, POOL_REMOVE_ABANDONED_TIMEOUT)).setTestOnBorrow(JdbcDatasource.parseBoolean(datasourceElement, POOL_TEST_ON_BORROW)).setTestOnReturn(JdbcDatasource.parseBoolean(datasourceElement, POOL_TEST_ON_RETURN)).setTestWhileIdle(JdbcDatasource.parseBoolean(datasourceElement, POOL_TEST_WHILE_IDLE)).setValidationQueryTimeout(JdbcDatasource.parseInteger(datasourceElement, VALIDATION_QUERY_TIMEOUT)).build();
        return new Builder().setJdbcUrl(datasourceElement.elementText(URL)).setDriverClassName(datasourceElement.elementText(DRIVER_CLASS)).setUsername(datasourceElement.elementText(USERNAME)).setPassword(datasourceElement.elementText(PASSWORD)).setConnectionProperties(connectionProperties).setConnectionPoolInfo(poolInfo).build();
    }

    private static Boolean parseBoolean(Element element, String key) {
        String value = element.elementText(key);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        log.warn((Object)("Invalid value for '" + key + "': '" + value + '\''));
        return null;
    }

    private static Integer parseInteger(Element element, String key) {
        String value = element.elementText(key);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Invalid value for '" + key + "': '" + value + '\''));
            return null;
        }
    }

    private static Long parseLong(Element element, String key) {
        String value = element.elementText(key);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Invalid value for '" + key + "': '" + value + '\''));
            return null;
        }
    }

    private static Properties parseConnectionProperties(String value) {
        String[] keyValues;
        if (value == null || value.length() == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (String keyValueText : keyValues = value.split(";")) {
            KeyValuePair<String, String> keyValuePair = KeyValueParser.parse(keyValueText);
            properties.setProperty(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return properties;
    }

    private void writeValue(Element element, String key, String value) {
        element.addElement(key).setText(value);
    }

    private void writeValue(Element element, String key, int value) {
        element.addElement(key).setText(String.valueOf(value));
    }

    private void writeValue(Element element, String key, long value) {
        element.addElement(key).setText(Long.toString(value));
    }

    private void writeOptionalValue(Element element, String key, long value, long defaultValue) {
        if (value != defaultValue) {
            this.writeValue(element, key, value);
        }
    }

    private void writeOptionalValue(Element element, String key, Object value) {
        if (value != null) {
            element.addElement(key).setText(value.toString());
        }
    }

    public void writeTo(Element element) {
        Element jdbc = element.addElement(JDBC_DATASOURCE);
        this.writeValue(jdbc, URL, this.getJdbcUrl());
        this.writeValue(jdbc, DRIVER_CLASS, this.getDriverClassName());
        this.writeValue(jdbc, USERNAME, this.getUsername());
        this.writeValue(jdbc, PASSWORD, this.getPassword());
        ConnectionPoolInfo poolInfo = this.getConnectionPoolInfo();
        this.writeValue(jdbc, POOL_MIN_SIZE, poolInfo.getMinSize());
        this.writeValue(jdbc, POOL_MAX_SIZE, poolInfo.getMaxSize());
        this.writeOptionalValue(jdbc, POOL_MAX_WAIT, poolInfo.getMaxWait(), 60000L);
        this.writeOptionalValue(jdbc, POOL_SLEEP_TIME, poolInfo.getSleepTime(), 300000L);
        this.writeOptionalValue(jdbc, POOL_LIFE_TIME, poolInfo.getLifeTime(), 600000L);
        this.writeOptionalValue(jdbc, DEADLOCK_MAX_WAIT, poolInfo.getDeadLockMaxWait(), 600000L);
        this.writeOptionalValue(jdbc, DEADLOCK_RETRY_WAIT, poolInfo.getDeadLockRetryWait(), 10000L);
        this.writeOptionalValue(jdbc, VALIDATION_QUERY, poolInfo.getValidationQuery());
        this.writeOptionalValue(jdbc, MIN_EVICTABLE_IDLE_TIME_MILLIS, poolInfo.getMinEvictableTimeMillis());
        this.writeOptionalValue(jdbc, TIME_BETWEEN_EVICTION_RUNS_MILLIS, poolInfo.getTimeBetweenEvictionRunsMillis());
        this.writeOptionalValue(jdbc, DEFAULT_CATALOG, poolInfo.getDefaultCatalog());
        this.writeOptionalValue(jdbc, MAX_OPEN_PREPARED_STATEMENTS, poolInfo.getMaxOpenPreparedStatements());
        this.writeOptionalValue(jdbc, POOL_NUM_TESTS_PER_EVICTION_RUN, poolInfo.getNumTestsPerEvictionRun());
        this.writeOptionalValue(jdbc, POOL_INITIAL_SIZE, poolInfo.getInitialSize());
        this.writeOptionalValue(jdbc, POOL_MAX_IDLE, poolInfo.getMaxIdle());
        this.writeOptionalValue(jdbc, POOL_PREPARED_STATEMENTS, poolInfo.getPoolPreparedStatements());
        this.writeOptionalValue(jdbc, POOL_REMOVE_ABANDONED, poolInfo.getRemoveAbandoned());
        this.writeOptionalValue(jdbc, POOL_REMOVE_ABANDONED_TIMEOUT, poolInfo.getRemoveAbandonedTimeout());
        this.writeOptionalValue(jdbc, POOL_TEST_ON_BORROW, poolInfo.getTestOnBorrow());
        this.writeOptionalValue(jdbc, POOL_TEST_ON_RETURN, poolInfo.getTestOnReturn());
        this.writeOptionalValue(jdbc, POOL_TEST_WHILE_IDLE, poolInfo.getTestWhileIdle());
        this.writeOptionalValue(jdbc, VALIDATION_QUERY_TIMEOUT, poolInfo.getValidationQueryTimeout());
    }

    public static class Builder {
        private DatabaseType databaseType;
        private String hostname;
        private String port;
        private String instance;
        private String jdbcUrl;
        private String driverClassName;
        private String username;
        private String password;
        private Properties connectionProperties;
        private ConnectionPoolInfo connectionPoolInfo;

        public JdbcDatasource build() {
            return new JdbcDatasource(this);
        }

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public Builder setDatabaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public String getPort() {
            return this.port;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public Builder setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public Builder setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public String getUsername() {
            return this.username;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Properties getConnectionProperties() {
            return this.connectionProperties;
        }

        public Builder setConnectionProperties(Properties connectionProperties) {
            this.connectionProperties = connectionProperties;
            return this;
        }

        public ConnectionPoolInfo getConnectionPoolInfo() {
            return this.connectionPoolInfo;
        }

        public Builder setConnectionPoolInfo(ConnectionPoolInfo connectionPoolInfo) {
            this.connectionPoolInfo = connectionPoolInfo;
            return this;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            return Builder.equals(this.databaseType, other.databaseType) && Builder.equals(this.hostname, other.hostname) && Builder.equals(this.port, other.port) && Builder.equals(this.instance, other.instance) && Builder.equals(this.jdbcUrl, other.jdbcUrl) && Builder.equals(this.driverClassName, other.driverClassName) && Builder.equals(this.username, other.username) && Builder.equals(this.password, other.password) && Builder.equals(this.connectionProperties, other.connectionProperties) && Builder.equals(this.connectionPoolInfo, other.connectionPoolInfo);
        }

        public int hashCode() {
            int h = 2020170315;
            h = Builder.hash(h, (Object)this.databaseType);
            h = Builder.hash(h, this.hostname);
            h = Builder.hash(h, this.port);
            h = Builder.hash(h, this.instance);
            h = Builder.hash(h, this.jdbcUrl);
            h = Builder.hash(h, this.driverClassName);
            h = Builder.hash(h, this.username);
            h = Builder.hash(h, this.password);
            h = Builder.hash(h, this.connectionProperties);
            h = Builder.hash(h, this.connectionPoolInfo);
            return h;
        }

        private static int hash(int h, Object o) {
            return h * 17 + (o != null ? o.hashCode() : 0);
        }

        private static <T> boolean equals(T o1, T o2) {
            return o1 != null ? o1.equals(o2) : o2 == null;
        }

        public String toString() {
            return ToStringBuilderExcludingPassword.reflectionToString((Object)this);
        }
    }
}

