/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.util.concurrent.LazyReference;

public class LazyLoadingCache<D> {
    private final CacheLoader<D> cacheLoader;
    private volatile DataReference reference;

    public LazyLoadingCache(CacheLoader<D> cacheLoader) {
        this.cacheLoader = cacheLoader;
        this.reset();
    }

    public D getData() {
        return (D)this.reference.get();
    }

    public synchronized void reload() {
        DataReference tempReference = new DataReference();
        tempReference.get();
        this.reference = tempReference;
    }

    public void reset() {
        this.reference = new DataReference();
    }

    private class DataReference
    extends LazyReference<D> {
        private DataReference() {
        }

        protected D create() throws Exception {
            return LazyLoadingCache.this.cacheLoader.loadData();
        }
    }

    public static interface CacheLoader<D> {
        public D loadData();
    }
}

