/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectService
implements ProjectService {
    private static final int MAX_FIELD_LENGTH = 255;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SchemeFactory schemeFactory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private final AvatarManager avatarManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final WorkflowManager workflowManager;

    public DefaultProjectService(JiraAuthenticationContext jiraAuthenticationContext, ProjectManager projectManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SchemeFactory schemeFactory, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, CustomFieldManager customFieldManager, NodeAssociationStore nodeAssociationStore, VersionManager versionManager, ProjectComponentManager projectComponentManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, AvatarManager avatarManager, I18nHelper.BeanFactory i18nFactory, WorkflowManager workflowManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.schemeFactory = schemeFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.customFieldManager = customFieldManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.avatarManager = avatarManager;
        this.i18nFactory = i18nFactory;
        this.workflowManager = workflowManager;
    }

    public ProjectService.CreateProjectValidationResult validateCreateProject(User user, String name, String key, String description, String lead, String url, Long assigneeType) {
        return this.validateCreateProject(user, name, key, description, lead, url, assigneeType, null);
    }

    public ProjectService.CreateProjectValidationResult validateCreateProject(User user, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId) {
        JiraServiceContext serviceContext = this.getServiceContext(user, (ErrorCollection)new SimpleErrorCollection());
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            serviceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"));
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        this.isValidAllProjectData(serviceContext, name, key, lead, url, assigneeType, avatarId);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection(), name, key, description, lead, url, assigneeType, avatarId);
    }

    protected JiraServiceContext getServiceContext(User user, ErrorCollection errorCollection) {
        return new JiraServiceContextImpl(user, errorCollection);
    }

    public Project createProject(ProjectService.CreateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not create a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not create a project with an invalid validation result.");
        }
        Project newProject = this.projectManager.createProject(result.getName(), result.getKey().toUpperCase(), result.getDescription(), result.getLead(), result.getUrl(), result.getAssigneeType(), result.getAvatarId());
        this.issueTypeScreenSchemeManager.associateWithDefaultScheme(newProject);
        this.workflowSchemeManager.clearWorkflowCache();
        return newProject;
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(User user, String name, String key, String description, String lead, String url, Long assigneeType) {
        return this.validateUpdateProject(user, name, key, description, lead, url, assigneeType, null);
    }

    public ServiceResult validateUpdateProject(User user, String key) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            errorCollection.addErrorCollection(oldProjectResult.getErrorCollection());
            return new ServiceResultImpl((ErrorCollection)errorCollection);
        }
        return new ServiceResultImpl((ErrorCollection)errorCollection);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(User user, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId) {
        ServiceResult validateUserAndKey = this.validateUpdateProject(user, key);
        if (!validateUserAndKey.isValid()) {
            return new ProjectService.UpdateProjectValidationResult(validateUserAndKey.getErrorCollection());
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        ErrorCollection validationErrors = this.validateUpdateProjectData(user, name, oldProjectResult.getProject(), lead, url, assigneeType, avatarId);
        if (validationErrors.hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult(validationErrors);
        }
        return new ProjectService.UpdateProjectValidationResult((ErrorCollection)errorCollection, name, key, description, lead, url, assigneeType, avatarId, oldProjectResult.getProject());
    }

    public Project updateProject(ProjectService.UpdateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update a project with an invalid validation result.");
        }
        return this.projectManager.updateProject(result.getOriginalProject(), result.getName(), result.getDescription(), result.getLead(), result.getUrl(), result.getAssigneeType(), result.getAvatarId());
    }

    public ProjectService.UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(User user, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
        GenericValue scheme;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"));
            return new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection);
        }
        if (permissionSchemeId != null && !new Long(-1L).equals(permissionSchemeId)) {
            try {
                scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved"));
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved.error", e.getMessage()));
            }
        }
        if (notificationSchemeId != null && !new Long(-1L).equals(notificationSchemeId)) {
            try {
                scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved"));
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved.error", e.getMessage()));
            }
        }
        if (issueSecuritySchemeId != null && !new Long(-1L).equals(issueSecuritySchemeId)) {
            try {
                scheme = this.issueSecuritySchemeManager.getScheme(issueSecuritySchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.issuesecurity.scheme.not.retrieved"));
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.issuesecurity.scheme.not.retrieved.error", e.getMessage()));
            }
        }
        if (errorCollection.hasAnyErrors()) {
            return new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection);
        }
        return new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection, permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
    }

    public void updateProjectSchemes(ProjectService.UpdateProjectSchemesValidationResult result, Project project) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update project schemes with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update project schemes with an invalid validation result.");
        }
        if (project == null) {
            throw new IllegalArgumentException("You can not update project schemes for a null project.");
        }
        Long permissionSchemeId = result.getPermissionSchemeId();
        Long notificationSchemeId = result.getNotificationSchemeId();
        Long issueSecuritySchemeId = result.getIssueSecuritySchemeId();
        try {
            GenericValue scheme;
            this.notificationSchemeManager.removeSchemesFromProject(project);
            if (notificationSchemeId != null && !new Long(-1L).equals(notificationSchemeId)) {
                scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                this.notificationSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
            }
            if (permissionSchemeId != null && !new Long(-1L).equals(permissionSchemeId)) {
                this.permissionSchemeManager.removeSchemesFromProject(project);
                scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                this.permissionSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
            }
            this.issueSecuritySchemeManager.removeSchemesFromProject(project);
            if (issueSecuritySchemeId != null && !new Long(-1L).equals(issueSecuritySchemeId)) {
                scheme = this.issueSecuritySchemeManager.getScheme(issueSecuritySchemeId);
                this.issueSecuritySchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public boolean isValidAllProjectData(JiraServiceContext serviceContext, String name, String key, String lead, String url, Long assigneeType) {
        return this.isValidAllProjectData(serviceContext, name, key, lead, url, assigneeType, null);
    }

    public boolean isValidAllProjectData(JiraServiceContext serviceContext, String name, String key, String lead, String url, Long assigneeType, Long avatarId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nHelper = serviceContext.getI18nBean();
        this.isValidRequiredProjectData(this.getServiceContext(serviceContext.getLoggedInUser(), (ErrorCollection)errorCollection), name, key, lead);
        this.validateProjectUrl(url, (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectAssigneeType(assigneeType, (ErrorCollection)errorCollection, i18nHelper);
        this.validateAvatarId(avatarId, this.projectManager.getProjectObjByKey(key), (ErrorCollection)errorCollection, i18nHelper);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public boolean isValidRequiredProjectData(JiraServiceContext serviceContext, String name, String key, String lead) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = serviceContext.getI18nBean();
        this.validateProjectName(name, (ErrorCollection)errorCollection, i18nBean);
        this.validateProjectKey(key, (ErrorCollection)errorCollection, i18nBean);
        this.validateProjectLead(lead, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public boolean isValidProjectKey(JiraServiceContext serviceContext, String key) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = serviceContext.getI18nBean();
        this.validateProjectKey(key, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    private ErrorCollection validateUpdateProjectData(User user, String name, Project oldProject, String lead, String url, Long assigneeType, Long avatarId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.getI18nBean(user);
        this.validateProjectNameForUpdate(name, oldProject.getKey(), (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectLead(lead, (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectUrl(url, (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectAssigneeType(assigneeType, (ErrorCollection)errorCollection, i18nHelper);
        this.validateAvatarId(avatarId, oldProject, (ErrorCollection)errorCollection, i18nHelper);
        return errorCollection;
    }

    public String getProjectKeyDescription() {
        String projectKeyDescription = this.applicationProperties.getDefaultBackedString("jira.projectkey.description");
        I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
        if (TextUtils.stringSet((String)projectKeyDescription)) {
            return i18nBean.getText(projectKeyDescription);
        }
        return i18nBean.getText("admin.projects.key.description");
    }

    public ProjectService.GetProjectResult getProjectByIdForAction(User user, Long id, ProjectAction action) {
        Project project = this.projectManager.getProjectObj(id);
        if (project == null || !this.checkActionPermission(user, project, ProjectAction.VIEW_PROJECT)) {
            return new ProjectNotFoundResult(user, "admin.errors.project.not.found.for.id", String.valueOf(id));
        }
        if (!this.checkActionPermission(user, project, action)) {
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    public ProjectService.GetProjectResult getProjectById(User user, Long id) {
        return this.getProjectByIdForAction(user, id, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKey(User user, String key) {
        return this.getProjectByKeyForAction(user, key, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKeyForAction(User user, String key, ProjectAction action) {
        Assertions.notNull((String)"action", (Object)action);
        Project project = this.projectManager.getProjectObjByKey(key);
        if (project == null || !this.checkActionPermission(user, project, ProjectAction.VIEW_PROJECT)) {
            return new ProjectNotFoundResult(user, "admin.errors.project.not.found.for.key", key);
        }
        if (!this.checkActionPermission(user, project, action)) {
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    public ServiceOutcome<List<Project>> getAllProjects(User user) {
        return this.getAllProjectsForAction(user, ProjectAction.VIEW_ISSUES);
    }

    public ServiceOutcome<List<Project>> getAllProjectsForAction(final User user, final ProjectAction action) {
        Iterable projects = Iterables.filter((Iterable)this.projectManager.getProjectObjects(), (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return input != null && DefaultProjectService.this.checkActionPermission(user, input, action);
            }
        });
        return new ServiceOutcomeImpl<List<Project>>((ErrorCollection)new SimpleErrorCollection(), Lists.newArrayList((Iterable)projects));
    }

    public ProjectService.DeleteProjectValidationResult validateDeleteProject(User user, String key) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"));
            return new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection);
        }
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            errorCollection.addErrorCollection(oldProjectResult.getErrorCollection());
            return new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection);
        }
        return new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection, oldProjectResult.getProject());
    }

    public ProjectService.DeleteProjectResult deleteProject(User user, ProjectService.DeleteProjectValidationResult result) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContext serviceContext = this.getServiceContext(user, (ErrorCollection)errorCollection);
        I18nHelper i18nBean = this.getI18nBean(user);
        if (result == null) {
            throw new IllegalArgumentException("You can not delete a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not delete a project with an invalid validation result.");
        }
        Project project = result.getProject();
        try {
            this.projectManager.removeProjectIssues(project);
        }
        catch (RemoveException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
        }
        this.customFieldManager.removeProjectAssociations(project);
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
        this.issueTypeScreenSchemeManager.removeSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
        Iterable workflowsAssociatedToProject = this.workflowManager.getWorkflowsFromScheme(this.workflowSchemeManager.getSchemeFor(project));
        try {
            this.nodeAssociationStore.removeAssociationsFromSource(project.getGenericValue());
            List allVersions = this.versionManager.getVersions(project.getId());
            for (Version version : allVersions) {
                this.versionManager.deleteVersion(version);
            }
            Collection components = this.projectComponentManager.findAllForProject(project.getId());
            for (ProjectComponent component : components) {
                this.projectComponentManager.delete(component.getId());
            }
        }
        catch (DataAccessException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
        }
        catch (EntityNotFoundException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
        }
        this.sharePermissionDeleteUtils.deleteProjectSharePermissions(project.getId());
        this.projectManager.removeProject(project);
        this.projectManager.refresh();
        this.workflowSchemeManager.clearWorkflowCache();
        this.workflowManager.copyAndDeleteDraftsForInactiveWorkflowsIn(user, workflowsAssociatedToProject);
        return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
    }

    private void validateProjectAssigneeType(Long assigneeType, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (assigneeType != null && !ProjectAssigneeTypes.isValidType(assigneeType)) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.default.assignee"));
        }
    }

    private void validateAvatarId(Long avatarId, Project oldProject, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (avatarId == null) {
            return;
        }
        Avatar avatar = this.avatarManager.getById(avatarId);
        if (avatar != null && !avatar.isSystemAvatar() && !oldProject.getId().toString().equals(avatar.getOwner())) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.avatar"));
        }
    }

    private void validateProjectUrl(String url, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (TextUtils.stringSet((String)url)) {
            if (url.length() > 255) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.project.url.too.long"));
            } else if (!TextUtils.verifyUrl((String)url)) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.url.specified.is.not.valid"));
            }
        }
    }

    private void validateProjectKey(String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!this.isProjectKeyValid(key)) {
            String projectKeyWarning = this.applicationProperties.getDefaultBackedString("jira.projectkey.warning");
            if (TextUtils.stringSet((String)projectKeyWarning)) {
                errorCollection.addError("projectKey", i18nBean.getText(projectKeyWarning));
            } else {
                errorCollection.addError("projectKey", i18nBean.getText("admin.errors.must.specify.unique.project.key"));
            }
        } else if (this.isReservedKeyword(key)) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.keyword.invalid"));
        } else if (key.length() > 10) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.key.too.long", (Object)10));
        } else {
            Project project = this.projectManager.getProjectObjByKey(key);
            if (project != null) {
                errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists"));
            }
        }
    }

    private void validateProjectLead(String lead, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!TextUtils.stringSet((String)lead)) {
            errorCollection.addError("projectLead", i18nBean.getText("admin.errors.must.specify.project.lead"));
        } else if (!this.checkUserExists(lead)) {
            errorCollection.addError("projectLead", i18nBean.getText("admin.errors.not.a.valid.user"));
        }
    }

    private void validateProjectName(String name, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!TextUtils.stringSet((String)name)) {
            errorCollection.addError("projectName", i18nBean.getText("admin.errors.must.specify.a.valid.project.name"));
        } else if (name.length() > 80) {
            errorCollection.addError("projectName", i18nBean.getText("admin.errors.project.name.too.long", (Object)80));
        } else {
            Project project = this.projectManager.getProjectObjByName(name);
            if (project != null) {
                errorCollection.addError("projectName", i18nBean.getText("admin.errors.project.with.that.name.already.exists"));
            }
        }
    }

    private void validateProjectNameForUpdate(String name, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!TextUtils.stringSet((String)name)) {
            errorCollection.addError("projectName", i18nBean.getText("admin.errors.must.specify.a.valid.project.name"));
        } else if (name.length() > 80) {
            errorCollection.addError("projectName", i18nBean.getText("admin.errors.project.name.too.long", (Object)80));
        } else {
            Project project = this.projectManager.getProjectObjByName(name);
            if (project != null && !key.equals(project.getKey())) {
                errorCollection.addError("projectName", i18nBean.getText("admin.errors.project.with.that.name.already.exists"));
            }
        }
    }

    protected final I18nHelper getI18nBean(User user) {
        return this.i18nFactory.getInstance(user);
    }

    boolean checkUserExists(String lead) {
        return UserUtils.userExists((String)lead);
    }

    boolean isReservedKeyword(String key) {
        return JiraKeyUtils.isReservedKeyword((String)key);
    }

    boolean isProjectKeyValid(String key) {
        return JiraKeyUtils.validProjectKey((String)key);
    }

    boolean checkActionPermission(User user, Project project, ProjectAction action) {
        return action.hasPermission(this.permissionManager, user, project);
    }

    protected final ErrorCollection makeErrorCollection(User user, String i18nKey, ErrorCollection.Reason reason, String ... params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessage(this.getI18nBean(user).getText(i18nKey, (Object)params), reason);
        if (reason == ErrorCollection.Reason.FORBIDDEN && user == null) {
            errors.addErrorMessage(this.getI18nBean(user).getText("common.forms.ajax.unauthorised.alert"), ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        return errors;
    }

    protected class PermissionErrorResult
    extends ProjectService.GetProjectResult {
        protected PermissionErrorResult(User user, ProjectAction action) {
            super(DefaultProjectService.this.makeErrorCollection(user, action.getErrorKey(), ErrorCollection.Reason.FORBIDDEN, new String[0]));
        }
    }

    protected class ProjectNotFoundResult
    extends ProjectService.GetProjectResult {
        protected ProjectNotFoundResult(User user, String i18nKey, String ... params) {
            super(DefaultProjectService.this.makeErrorCollection(user, i18nKey, ErrorCollection.Reason.NOT_FOUND, params));
        }
    }
}

