/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.table;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.issue.table.IssueTableService;
import com.atlassian.jira.bc.issue.table.IssueTableServiceConfiguration;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.table.IssueTable;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssuePager;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.component.TableLayoutUtils;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultIssueTableService
implements IssueTableService {
    private static final Logger log = Logger.getLogger(DefaultIssueTableService.class);
    private final SearchService searchService;
    private final SearchSortUtil searchSortUtil;
    private final JiraAuthenticationContext authenticationContext;
    private final ColumnLayoutManager columnLayoutManager;
    private final TableLayoutUtils tableLayoutUtils;
    private final JqlStringSupport jqlStringSupport;
    private final SearchProvider searchProvider;
    private final FieldManager fieldManager;
    private final ApplicationProperties applicationProperties;
    private final SearchRequestService searchRequestService;
    private static final String COLUMN_NAMES = "columnNames";
    private static final int DEFAULT_MAX_ROWS = 50;
    private static final String NUM_FIELD = "num";
    private static final String JQL_PREFIX = "jql-";
    private static final String FILTER_ID = "filterId";
    private static final String FILTER_PREFIX = "filter-";

    public DefaultIssueTableService(SearchService searchService, SearchSortUtil searchSortUtil, JiraAuthenticationContext authenticationContext, ColumnLayoutManager columnLayoutManager, TableLayoutUtils tableLayoutUtils, JqlStringSupport jqlStringSupport, SearchProvider searchProvider, FieldManager fieldManager, ApplicationProperties applicationProperties, SearchRequestService searchRequestService) {
        this.searchService = searchService;
        this.searchSortUtil = searchSortUtil;
        this.authenticationContext = authenticationContext;
        this.columnLayoutManager = columnLayoutManager;
        this.tableLayoutUtils = tableLayoutUtils;
        this.jqlStringSupport = jqlStringSupport;
        this.searchProvider = searchProvider;
        this.fieldManager = fieldManager;
        this.applicationProperties = applicationProperties;
        this.searchRequestService = searchRequestService;
    }

    public ServiceOutcome<IssueTable> getIssueTableFromJQL(String jql) {
        return this.getIssueTableFromJQL(jql, new IssueTableServiceConfiguration());
    }

    public ServiceOutcome<IssueTable> getIssueTableFromJQL(String jql, IssueTableServiceConfiguration configuration) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        User user = this.authenticationContext.getLoggedInUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            for (String errorMessage : parseResult.getErrors().getErrorMessages()) {
                errors.addErrorMessage(errorMessage);
            }
            if (!errors.hasAnyErrors()) {
                errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("jql.parse.unknown.no.pos"));
            }
            return new ServiceOutcomeImpl<IssueTable>((ErrorCollection)errors);
        }
        return this.getIssueTable(parseResult.getQuery(), user, configuration);
    }

    public ServiceOutcome<IssueTable> getIssueTableFromFilter(String filterId) {
        IssueTableServiceConfiguration configuration = new IssueTableServiceConfiguration();
        return this.getIssueTableFromFilter(filterId, configuration);
    }

    public ServiceOutcome<IssueTable> getIssueTableFromFilter(String filterId, IssueTableServiceConfiguration configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SearchRequest searchRequest = this.getSearchRequestAndValidate(filterId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return new ServiceOutcomeImpl<IssueTable>((ErrorCollection)errorCollection);
        }
        Query query = searchRequest.getQuery();
        User user = this.authenticationContext.getLoggedInUser();
        return this.getIssueTable(query, user, configuration);
    }

    private ServiceOutcome<IssueTable> getIssueTable(Query query, User user, IssueTableServiceConfiguration configuration) {
        query = this.addOrderByToSearchRequest(query, configuration.getSortBy());
        List<ColumnLayoutItem> columns = this.getColumns(configuration.getContext(), configuration.getColumnNames(), configuration.isAddDefaults(), configuration.isUseConfiguredColumns());
        Map<String, String> columnSortJql = this.generateColumnSortJql(query, columns);
        IssueTableLayoutBean layout = this.createLayout(query, columns, configuration.isEnableSorting(), configuration.isDisplayHeader(), configuration.isShowActions());
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        int validatedNumberToShow = this.validateNumberToShow(NUM_FIELD, configuration.getNumberToShow(), (ErrorCollection)errorCollection);
        PagerFilter pagerFilter = new PagerFilter(validatedNumberToShow);
        pagerFilter.setStart(configuration.getStart());
        try {
            SearchResults results = this.searchProvider.search(query, user, pagerFilter);
            IssueTable issueTable = this.createIssueTable(results, layout, configuration.isPaging(), configuration.getNumberToShow(), columnSortJql);
            return new ServiceOutcomeImpl<IssueTable>((ErrorCollection)errorCollection, issueTable);
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                String message = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.admin");
                errorCollection.addErrorMessage(message);
            } else {
                log.error((Object)e);
                String message = this.authenticationContext.getI18nHelper().getText("unknown.search.error");
                errorCollection.addErrorMessage(message);
            }
        }
        catch (SearchException e) {
            log.error((Object)e);
            String message = this.authenticationContext.getI18nHelper().getText("unknown.search.error");
            errorCollection.addErrorMessage(message);
        }
        return new ServiceOutcomeImpl<IssueTable>((ErrorCollection)errorCollection);
    }

    ServiceOutcome<IssueTable> validateJql(IssueTableServiceConfiguration config) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.validateColumnNames(config.getColumnNames(), (ErrorCollection)errorCollection);
        this.validateNumberToShow(NUM_FIELD, config.getNumberToShow(), (ErrorCollection)errorCollection);
        return new ServiceOutcomeImpl<IssueTable>((ErrorCollection)errorCollection);
    }

    private Map<String, String> generateColumnSortJql(Query query, List<ColumnLayoutItem> columns) {
        HashMap<String, String> columnSortJql = new HashMap<String, String>();
        for (ColumnLayoutItem column : columns) {
            String id = column.getNavigableField().getId();
            OrderBy ob = this.buildOrderBy(query.getOrderByClause(), id);
            QueryImpl queryWithOrder = new QueryImpl(query.getWhereClause(), ob, null);
            columnSortJql.put(id, this.jqlStringSupport.generateJqlString((Query)queryWithOrder));
        }
        return columnSortJql;
    }

    private SearchRequest getSearchRequestAndValidate(String filterId, ErrorCollection errors) {
        User user = this.authenticationContext.getLoggedInUser();
        SearchRequest searchRequest = null;
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
        if (StringUtils.isBlank((String)filterId)) {
            errors.addError(FILTER_ID, this.authenticationContext.getI18nHelper().getText("gadget.common.no.filter.id"));
        } else {
            if (filterId.startsWith(JQL_PREFIX)) {
                SearchService.ParseResult parseResult = this.searchService.parseQuery(user, filterId.substring(JQL_PREFIX.length()));
                if (parseResult.isValid()) {
                    searchRequest = new SearchRequest(parseResult.getQuery());
                } else {
                    for (String errorMessage : parseResult.getErrors().getErrorMessages()) {
                        errors.addError(FILTER_ID, this.authenticationContext.getI18nHelper().getText("gadget.common.invalid.filter.validationfailed", (Object)CollectionBuilder.newBuilder((Object[])new String[]{filterId, errorMessage}).asList()));
                    }
                }
            } else {
                searchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, this.stripFilterPrefix(filterId, FILTER_PREFIX));
            }
            if (searchRequest == null) {
                errors.addError(FILTER_ID, this.authenticationContext.getI18nHelper().getText("gadget.common.invalid.filter.id", filterId));
            } else {
                MessageSet messageSet = this.searchService.validateQuery(user, searchRequest.getQuery());
                if (messageSet.hasAnyErrors()) {
                    for (String errorMessage : messageSet.getErrorMessages()) {
                        errors.addError(FILTER_ID, this.authenticationContext.getI18nHelper().getText("gadget.common.invalid.filter.validationfailed", (Object)CollectionBuilder.newBuilder((Object[])new String[]{filterId, errorMessage}).asList()));
                    }
                }
            }
        }
        return searchRequest;
    }

    private IssueTable createIssueTable(SearchResults results, IssueTableLayoutBean layout, boolean isPaging, int numberToShow, Map<String, String> columnSortJql) {
        String html = results.getIssues().isEmpty() ? null : new IssueTableWebComponent().getHtml(layout, results.getIssues(), (IssuePager)(isPaging ? results : null));
        String url = "";
        String name = "";
        String description = "";
        return new IssueTable(html, results.getIssues().size(), results.getTotal(), results.getNiceStart(), results.getEnd(), 0, numberToShow, "", "", "", columnSortJql);
    }

    private IssueTableLayoutBean createLayout(Query query, List<ColumnLayoutItem> columns, boolean enableSorting, boolean displayHeader, boolean showActions) {
        OrderBy orderBy = query.getOrderByClause();
        IssueTableLayoutBean layout = new IssueTableLayoutBean(columns, (Collection)orderBy.getSearchSorts());
        layout.setSortingEnabled(enableSorting);
        layout.setDisplayHeader(displayHeader);
        layout.setShowExteriorTable(false);
        layout.setShowActionColumn(showActions);
        layout.setTableCssClass("grid issuetable-db maxWidth");
        layout.setDisplayHeaderPager(false);
        return layout;
    }

    private OrderBy buildOrderBy(OrderBy ob, String columnName) {
        ArrayList<SearchSort> newSearchSortList = new ArrayList<SearchSort>();
        SortOrder columnDirection = SortOrder.ASC;
        for (SearchSort searchSort : ob.getSearchSorts()) {
            if (searchSort.getField().equals(columnName)) {
                if (searchSort.getSortOrder() != SortOrder.ASC) continue;
                columnDirection = SortOrder.DESC;
                continue;
            }
            newSearchSortList.add(searchSort);
        }
        newSearchSortList.add(0, new SearchSort(columnName, columnDirection));
        return new OrderByImpl(newSearchSortList);
    }

    private List<ColumnLayoutItem> getColumns(String context, List<String> columnNames, boolean addDefaults, boolean useConfiguredCols) {
        User user = this.authenticationContext.getLoggedInUser();
        try {
            if (useConfiguredCols) {
                ColumnLayout columnLayout = this.columnLayoutManager.getColumnLayout(user);
                return columnLayout.getAllVisibleColumnLayoutItems(user);
            }
            List list = this.tableLayoutUtils.getColumns(user, context, columnNames, addDefaults);
            if (columnNames != null && columnNames.size() == 1 && list.size() != 1 && (columnNames = Arrays.asList(columnNames.get(0).split(","))).size() > 1) {
                list = this.tableLayoutUtils.getColumns(user, context, columnNames, addDefaults);
            }
            return list;
        }
        catch (FieldException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ColumnLayoutException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ColumnLayoutStorageException e) {
            log.error((Object)"Exception thrown while retreiving fields for issue table gadget", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    Query addOrderByToSearchRequest(Query preOrderByQuery, String sortBy) {
        if (StringUtils.isNotBlank((String)sortBy)) {
            String sortDirection = null;
            if (sortBy.endsWith(":DESC") || sortBy.endsWith(":ASC")) {
                sortDirection = sortBy.substring(sortBy.lastIndexOf(58) + 1);
                sortBy = sortBy.substring(0, sortBy.lastIndexOf(58));
            }
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)preOrderByQuery);
            String[] sortArray = new String[]{sortDirection};
            String[] fieldArray = new String[]{sortBy};
            MapBuilder builder = MapBuilder.newBuilder();
            Map params = builder.add((Object)"sorter/order", (Object)sortArray).add((Object)"sorter/field", (Object)fieldArray).toMap();
            OrderBy newOrder = this.searchSortUtil.getOrderByClause(params);
            OrderBy oldOrder = queryBuilder.orderBy().buildOrderBy();
            User user = this.authenticationContext.getLoggedInUser();
            List newSearchSorts = newOrder.getSearchSorts();
            List oldSearchSorts = oldOrder.getSearchSorts();
            List sorts = this.searchSortUtil.mergeSearchSorts(user, (Collection)newSearchSorts, (Collection)oldSearchSorts, 3);
            queryBuilder.orderBy().setSorts((Collection)sorts);
            return queryBuilder.buildQuery();
        }
        return preOrderByQuery;
    }

    private int validateNumberToShow(String fieldName, int numberToShow, ErrorCollection errors) {
        try {
            int maxRows = this.getMaxRows();
            if (numberToShow <= 0) {
                errors.addError(fieldName, this.authenticationContext.getI18nHelper().getText("gadget.common.num.negative"));
            } else if (numberToShow > maxRows) {
                errors.addError(fieldName, this.authenticationContext.getI18nHelper().getText("gadget.common.num.overlimit"));
            }
            return numberToShow;
        }
        catch (NumberFormatException e) {
            errors.addError(fieldName, this.authenticationContext.getI18nHelper().getText("gadget.common.num.nan"));
            return -1;
        }
    }

    private int getMaxRows() {
        try {
            if (this.applicationProperties != null) {
                String maxRowsStr = this.applicationProperties.getDefaultBackedString("jira.table.gadget.max.rows");
                if (StringUtils.isNotBlank((String)maxRowsStr)) {
                    return Integer.valueOf(maxRowsStr);
                }
                String logMessage = "'jira.table.gadget.max.rows' doesn't exist in jira-application.properties";
                log.info((Object)"'jira.table.gadget.max.rows' doesn't exist in jira-application.properties");
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"'jira.table.gadget.max.rows' contains something thats not a number!", (Throwable)e);
        }
        return 50;
    }

    private Long stripFilterPrefix(String filterId, String prefix) {
        if (filterId.startsWith(prefix)) {
            String numPart = filterId.substring(prefix.length());
            return Long.valueOf(numPart);
        }
        return Long.valueOf(filterId);
    }

    void validateColumnNames(List<String> columnNames, ErrorCollection errors) {
        if (columnNames != null && !columnNames.isEmpty()) {
            try {
                ArrayList<String> fieldsNotFound = new ArrayList<String>();
                User user = this.authenticationContext.getLoggedInUser();
                Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
                for (String columnName : columnNames) {
                    if ("--default--".equalsIgnoreCase(columnName)) continue;
                    boolean found = false;
                    for (NavigableField availableField : availableFields) {
                        if (!columnName.equals(availableField.getId())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fieldsNotFound.add(columnName);
                }
                if (!fieldsNotFound.isEmpty()) {
                    String fieldsNotFoundString = StringUtils.join(fieldsNotFound, (String)", ");
                    errors.addError(COLUMN_NAMES, this.authenticationContext.getI18nHelper().getText("issue.table.service.invalid.columns", fieldsNotFoundString));
                }
            }
            catch (FieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

