/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.ProjectManager;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ComponentUtils {
    private static final Logger log = Logger.getLogger(ComponentUtils.class);

    public static boolean isProjectLeadAssignable(GenericValue entity) {
        try {
            GenericValue project;
            if ("Component".equals(entity.getEntityName())) {
                project = ComponentUtils.getProject(entity);
            } else if ("Project".equals(entity.getEntityName())) {
                project = entity;
            } else {
                throw new IllegalArgumentException("Entity passed must be \"Component\" or \"Project\" and NOT " + entity);
            }
            String projectLeadUsername = project.getString("lead");
            return ComponentUtils.isUserAssignable(project, projectLeadUsername);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean isComponentLeadAssignable(GenericValue component) {
        try {
            GenericValue project = ComponentUtils.getProject(component);
            String projectLeadUsername = component.getString("lead");
            return ComponentUtils.isUserAssignable(project, projectLeadUsername);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static long getComponentAssigneeType(GenericValue component) {
        if (component == null) {
            throw new IllegalArgumentException("Component passed can not be null.");
        }
        Long assigneeType = component.getLong("assigneetype");
        return ComponentUtils.getAssigneeType(component, assigneeType);
    }

    public static long getAssigneeType(GenericValue component, Long assigneeType) {
        if (assigneeType == null) {
            return 0L;
        }
        if (ComponentAssigneeTypes.isProjectLead(assigneeType)) {
            if (ComponentUtils.isProjectLeadAssignable(component)) {
                return 2L;
            }
            return 0L;
        }
        if (ComponentAssigneeTypes.isComponentLead(assigneeType)) {
            if (ComponentUtils.isComponentLeadAssignable(component)) {
                return 1L;
            }
            return 0L;
        }
        if (ComponentAssigneeTypes.isUnassigned(assigneeType)) {
            if (ComponentUtils.isIssueUnassignable(component)) {
                return 3L;
            }
            return 0L;
        }
        return 0L;
    }

    public static boolean isIssueUnassignable(GenericValue component) {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.allowunassigned");
    }

    private static boolean isUserAssignable(GenericValue project, String username) {
        if (username != null) {
            User user = ComponentAccessor.getUserManager().getUser(username);
            if (user != null) {
                return ComponentAccessor.getPermissionManager().hasPermission(17, project, user);
            }
            log.debug((Object)("User with username '" + username + "' is not assignable for project '" + project.getString("name") + "'! User does not exist!"));
            return false;
        }
        return false;
    }

    private static GenericValue getProject(GenericValue component) throws GenericEntityException {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        return projectManager.getProject(component.getLong("project"));
    }
}

