/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.validation;

import com.atlassian.core.util.StringUtils;
import com.atlassian.validation.ApplicationPropertyEnumerator;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import java.util.Set;

public final class EnumValidator
implements Validator {
    private final ApplicationPropertyEnumerator enumerator;

    public EnumValidator(ApplicationPropertyEnumerator enumerator) {
        this.enumerator = enumerator;
    }

    @Override
    public Validator.Result validate(String value) {
        Set<String> options = this.enumerator.getEnumeration();
        if (options.contains(value)) {
            return new Success(value);
        }
        String csv = StringUtils.createCommaSeperatedString(options);
        return new Failure("Only the following values are allowed: " + csv);
    }
}

