/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.issue.DocumentIssueImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IssueWorkflowManagerImpl
implements IssueWorkflowManager {
    private static final Logger log = Logger.getLogger(IssueWorkflowManagerImpl.class);
    private final IssueManager issueManager;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;

    public IssueWorkflowManagerImpl(IssueManager issueManager, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext) {
        this.issueManager = issueManager;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
    }

    public Collection<ActionDescriptor> getAvailableActions(Issue issue) {
        int[] actionIds = this.getAvailableActionIds(issue);
        ArrayList<ActionDescriptor> availableActions = new ArrayList<ActionDescriptor>(actionIds.length);
        WorkflowDescriptor workflowDescriptor = this.workflowManager.getWorkflow(issue).getDescriptor();
        for (int actionId : actionIds) {
            ActionDescriptor action = workflowDescriptor.getAction(actionId);
            if (action == null) {
                log.error((Object)("State of issue [" + issue + "] has an action [id=" + actionId + "] which cannot be found in the workflow descriptor"));
                continue;
            }
            availableActions.add(action);
        }
        return availableActions;
    }

    public List<ActionDescriptor> getSortedAvailableActions(Issue issue) {
        ArrayList availableActions = Lists.newArrayList(this.getAvailableActions(issue));
        Collections.sort(availableActions, new Comparator<ActionDescriptor>(){

            @Override
            public int compare(ActionDescriptor actionDescriptor, ActionDescriptor actionDescriptor1) {
                return IssueWorkflowManagerImpl.this.getSequenceFromAction(actionDescriptor).compareTo(IssueWorkflowManagerImpl.this.getSequenceFromAction(actionDescriptor1));
            }
        });
        return availableActions;
    }

    private Integer getSequenceFromAction(ActionDescriptor action) {
        if (action == null) {
            return Integer.MAX_VALUE;
        }
        Map metaAttributes = action.getMetaAttributes();
        if (metaAttributes == null) {
            return Integer.MAX_VALUE;
        }
        String value = (String)metaAttributes.get("opsbar-sequence");
        if (value == null || StringUtils.isBlank((String)value) || !StringUtils.isNumeric((String)value)) {
            return Integer.MAX_VALUE;
        }
        return Integer.valueOf(value);
    }

    public boolean isValidAction(Issue issue, int actionid) {
        for (int id : this.getAvailableActionIds(issue)) {
            if (id != actionid) continue;
            return true;
        }
        return false;
    }

    private int[] getAvailableActionIds(Issue issue) {
        Issue originalIssue;
        Project project = issue.getProjectObject();
        if (issue instanceof DocumentIssueImpl) {
            originalIssue = issue = this.issueManager.getIssueObject(issue.getId());
        } else {
            if (issue.getWorkflowId() == null) {
                log.error((Object)("!!! Issue " + issue.getKey() + " has no workflow ID !!! "));
                return new int[0];
            }
            originalIssue = this.issueManager.getIssueObject(issue.getId());
        }
        Workflow workflow = this.workflowManager.makeWorkflow(this.authenticationContext.getLoggedInUser());
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("pkey", project.getKey());
        inputs.put("issue", (String)issue);
        inputs.put("originalissueobject", (String)originalIssue);
        return workflow.getAvailableActions(issue.getWorkflowId().longValue(), inputs);
    }
}

