/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

abstract class AbstractWorkflowScheme
implements WorkflowScheme {
    private final Long id;
    private final String name;
    private final String description;
    private final Map<String, String> workflowMap;

    AbstractWorkflowScheme(Long id, String name, String description, Map<String, String> workflowMap) {
        this.description = description;
        this.id = id;
        this.name = name;
        this.workflowMap = Collections.unmodifiableMap(Maps.newHashMap(workflowMap));
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return false;
    }

    public String getWorkflow(String issueTypeId) {
        String workflow = this.workflowMap.get(issueTypeId);
        if (workflow == null) {
            workflow = this.getDefaultWorkflow();
        }
        return workflow;
    }

    public String getDefaultWorkflow() {
        String workflow = this.workflowMap.get(null);
        if (workflow == null) {
            workflow = "jira";
        }
        return workflow;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getWorkflowMap() {
        return this.workflowMap;
    }
}

