/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.web.util.CssSubstitutionWebResourceTransformer;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.transformer.AbstractStringTransformedDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class LessTransformer
implements WebResourceTransformer {
    private static final Pattern CSS_LITERAL = Pattern.compile("^(([A-Za-z-]+)|(#[A-Za-z0-9]+)|(\\d*\\.?\\d+? *(px|%|em|pc|ex|in|deg|s|ms|pt|cm|mm|rad|grad|turn)?)|[\"'])$");
    private static final String ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION = "atlassian.webresource.disable.minification";
    private static final Supplier<LessCompiler> LESSC = new LazyReference<LessCompiler>(){

        protected LessCompiler create() throws Exception {
            return new LessCompiler();
        }
    };
    private final ApplicationProperties applicationProperties;
    private final ServletContextFactory servletContextFactory;
    private final PluginAccessor pluginAccessor;
    private final WebResourceIntegration webResourceIntegration;

    public LessTransformer(ApplicationProperties applicationProperties, ServletContextFactory servletContextFactory, PluginAccessor pluginAccessor, WebResourceIntegration webResourceIntegration) throws IOException {
        this.applicationProperties = applicationProperties;
        this.servletContextFactory = servletContextFactory;
        this.pluginAccessor = pluginAccessor;
        this.webResourceIntegration = webResourceIntegration;
    }

    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String extrapath, DownloadableResource downloadableResource) {
        boolean minificationDisabled = this.isMinificationDisabled();
        if (minificationDisabled) {
            return new DevModeLessResource(LessTransformer.pluginKeyForElement(element), this.servletContextFactory.getServletContext(), resourceLocation, downloadableResource, minificationDisabled);
        }
        return new LessResource(LessTransformer.pluginKeyForElement(element), this.servletContextFactory.getServletContext(), resourceLocation, downloadableResource, minificationDisabled);
    }

    private static String pluginKeyForElement(Element element) {
        String pluginKey = null;
        Element p = element;
        while ((p = p.getParent()) != null) {
            if (!p.getName().equals("atlassian-plugin")) continue;
            pluginKey = p.attributeValue("key");
        }
        return pluginKey;
    }

    private boolean isMinificationDisabled() {
        return Boolean.getBoolean(ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION) || Boolean.getBoolean("atlassian.dev.mode");
    }

    private String makeLookAndFeelLess() {
        LookAndFeelBean laf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        CssSubstitutionWebResourceTransformer.VariableMap variableMap = new CssSubstitutionWebResourceTransformer.VariableMap(laf, this.webResourceIntegration);
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, String> entry : variableMap.getVariableMap(false).entrySet()) {
            out.append("@").append(entry.getKey()).append(": ");
            out.append(this.encodeValue(entry.getValue())).append(";\n");
        }
        return out.toString();
    }

    private String encodeValue(String value) {
        if (CSS_LITERAL.matcher(value = StringUtils.trimToEmpty((String)value)).matches()) {
            return value;
        }
        value = value.replaceAll("['\"]", "\\$0");
        return '\"' + value + '\"';
    }

    static class LessCompiler {
        private final Scriptable sharedScope;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LessCompiler() throws IOException {
            ContextFactory cf = new ContextFactory();
            Context cx = cf.enterContext();
            try {
                ScriptableObject scope = cx.initStandardObjects();
                cx.setOptimizationLevel(9);
                this.loadjs((Scriptable)scope, cx, "setup-env.js");
                this.loadjs((Scriptable)scope, cx, "less-concat.js");
                Function init = (Function)scope.get("init", (Scriptable)scope);
                init.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[0]);
                scope.sealObject();
                this.sharedScope = scope;
            }
            finally {
                Context.exit();
            }
        }

        private void loadjs(Scriptable topScope, Context cx, String name) throws IOException {
            InputStream in = this.getClass().getResourceAsStream(name);
            if (in == null) {
                throw new FileNotFoundException("Could not find JS resource " + name);
            }
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            cx.evaluateReader(topScope, (Reader)reader, name, 1, null);
        }

        public String compile(String location, LessResource.BaseLoader loader, String input, boolean compress) {
            ContextFactory cf = new ContextFactory();
            Context cx = cf.enterContext();
            try {
                Function runLessRun = (Function)this.sharedScope.get("runLessRun", this.sharedScope);
                Scriptable newScope = cx.newObject(this.sharedScope);
                newScope.setPrototype(this.sharedScope);
                newScope.setParentScope(null);
                try {
                    Object[] args = new Object[]{location, loader, input, compress};
                    Object result = runLessRun.call(cx, newScope, newScope, args);
                    String string = Context.toString((Object)result);
                    return string;
                }
                catch (JavaScriptException e) {
                    throw new RuntimeException(this.debugJsObject(cx, newScope, e.getValue()), e);
                }
            }
            finally {
                Context.exit();
            }
        }

        private String debugJsObject(Context cx, Scriptable scope, Object value) {
            Object v;
            Scriptable obj;
            if (value instanceof Scriptable && ScriptableObject.hasProperty((Scriptable)(obj = (Scriptable)value), (String)"toSource") && (v = ScriptableObject.getProperty((Scriptable)obj, (String)"toSource")) instanceof Function) {
                Function f = (Function)v;
                return String.valueOf(f.call(cx, scope, obj, new Object[0]));
            }
            return String.valueOf(value);
        }
    }

    private class DevModeLessResource
    extends LessResource {
        DevModeLessResource(String pluginKey, ServletContext servletContext, ResourceLocation originalLocation, DownloadableResource originalResource, boolean minificationEnabled) {
            super(pluginKey, servletContext, originalLocation, originalResource, minificationEnabled);
        }

        @Override
        protected String transform(String originalContent) {
            return "/*\n * Name: " + this.getOriginalLocation().getName() + "\n * File: " + this.getOriginalLocation().getLocation() + "\n */\n\n" + super.transform(originalContent);
        }
    }

    private class LessResource
    extends AbstractStringTransformedDownloadableResource {
        private final String pluginKey;
        private final ServletContext servletContext;
        private final ResourceLocation originalLocation;
        private final BaseLoader loader;
        private final boolean minificationDisabled;

        private LessResource(String pluginKey, ServletContext servletContext, ResourceLocation originalLocation, DownloadableResource originalResource, boolean minificationDisabled) {
            super(originalResource);
            this.pluginKey = pluginKey;
            this.servletContext = servletContext;
            this.originalLocation = originalLocation;
            this.minificationDisabled = minificationDisabled;
            String sourceParam = originalLocation.getParameter("source");
            this.loader = "webContextStatic".equalsIgnoreCase(sourceParam) ? new WebContextLoader() : new PluginLoader();
        }

        public String getContentType() {
            return "text/css";
        }

        protected String transform(String originalContent) {
            return ((LessCompiler)LESSC.get()).compile(this.originalLocation.getLocation(), this.loader, originalContent, !this.minificationDisabled);
        }

        protected ResourceLocation getOriginalLocation() {
            return this.originalLocation;
        }

        public class WebContextLoader
        extends BaseLoader {
            @Override
            protected InputStream getResourceInputStream(String destPath) {
                return LessResource.this.servletContext.getResourceAsStream(destPath);
            }
        }

        public class PluginLoader
        extends BaseLoader {
            @Override
            protected InputStream getResourceInputStream(String destPath) {
                if (LessResource.this.pluginKey == null) {
                    throw new IllegalStateException("Cannot load resource because could not find plugin key from transformer, resource=" + destPath);
                }
                Plugin plugin = LessTransformer.this.pluginAccessor.getPlugin(LessResource.this.pluginKey);
                if (plugin == null) {
                    throw new IllegalStateException("Cannot load resource because could not find plugin plugin=" + LessResource.this.pluginKey);
                }
                return plugin.getResourceAsStream(destPath);
            }
        }

        public abstract class BaseLoader {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String load(String url) throws URISyntaxException, IOException {
                if (url.endsWith("dynamic:lookandfeel.less")) {
                    return LessTransformer.this.makeLookAndFeelLess();
                }
                URI destUri = new URI(LessResource.this.originalLocation.getLocation()).resolve(url);
                String destPath = destUri.getPath();
                InputStream in = null;
                try {
                    in = this.getResourceInputStream(destPath);
                    if (in == null) {
                        throw new FileNotFoundException("Could not find resource: " + destUri + ", from " + url);
                    }
                    String string = IOUtils.toString((InputStream)in);
                    return string;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }

            protected abstract InputStream getResourceInputStream(String var1);
        }
    }
}

