/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public abstract class AbstractEditWorkflowTransitionDescriptorParams
extends AbstractWorkflowTransitionAction {
    private AbstractDescriptor workflowDescriptor;
    private String count = "";
    private Map descriptorParams;
    private AbstractWorkflowModuleDescriptor workflowModuleDescriptor;

    public AbstractEditWorkflowTransitionDescriptorParams(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public AbstractEditWorkflowTransitionDescriptorParams(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    public String doDefault() throws Exception {
        if (!TextUtils.stringSet((String)this.getCount())) {
            this.addErrorMessage(this.getText("admin.errors.workflows.cannot.find.count"));
        }
        if (this.getIndexCount() < 0) {
            this.addErrorMessage(this.getText("admin.errors.workflows.count.must.be.positive"));
        }
        if (this.invalidInput()) {
            return "error";
        }
        this.setupWorkflowDescriptor();
        this.setupWorkflowModuleDescriptor();
        return super.doDefault();
    }

    protected void doValidation() {
        this.setupWorkflowDescriptor();
        this.setupWorkflowModuleDescriptor();
        this.setupWorkflowDescriptorParams(ActionContext.getParameters());
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.editWorkflowDescriptor(this.workflowDescriptor, this.descriptorParams);
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getRedirect(this.getRedirectUrl());
    }

    protected String getRedirectUrl() {
        String redirectUrl = this.getStep() == null ? "ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowTransition=" + this.getTransition().getId() + "&currentCount=" + this.getHighLightParamPrefix() + this.getCount() : "ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId() + "&currentCount=" + this.getHighLightParamPrefix() + this.getCount();
        if (TextUtils.stringSet((String)this.getCount())) {
            redirectUrl = redirectUrl + "&currentCount=" + this.getCount();
        }
        return redirectUrl;
    }

    protected abstract String getHighLightParamPrefix();

    protected void setupWorkflowModuleDescriptor() {
        String type = null;
        Map args = null;
        if (this.workflowDescriptor instanceof FunctionDescriptor) {
            type = ((FunctionDescriptor)this.workflowDescriptor).getType();
            args = ((FunctionDescriptor)this.workflowDescriptor).getArgs();
        } else if (this.workflowDescriptor instanceof ConditionDescriptor) {
            type = ((ConditionDescriptor)this.workflowDescriptor).getType();
            args = ((ConditionDescriptor)this.workflowDescriptor).getArgs();
        } else if (this.workflowDescriptor instanceof ValidatorDescriptor) {
            type = ((ValidatorDescriptor)this.workflowDescriptor).getType();
            args = ((ValidatorDescriptor)this.workflowDescriptor).getArgs();
        } else {
            throw new IllegalArgumentException("Invalid workflowDescriptor type");
        }
        if ("class".equalsIgnoreCase(type) && args.containsKey("class.name")) {
            String className = (String)args.get("class.name");
            try {
                this.workflowModuleDescriptor = this.getWorkflowModuleDescriptor(className, this.getPluginType());
                return;
            }
            catch (PluginParseException e) {
                String message = "Cannot find module descriptor.";
                this.log.error((Object)"Cannot find module descriptor.", (Throwable)e);
                throw new RuntimeException("Cannot find module descriptor.", e);
            }
        }
        throw new IllegalArgumentException("Cannot find workflowDescriptor.");
    }

    protected AbstractWorkflowModuleDescriptor getWorkflowModuleDescriptor(String className, String pluginType) throws PluginParseException {
        List moduleDescriptors = this.getPluginAccessor().getEnabledModuleDescriptorsByType(pluginType);
        for (AbstractWorkflowModuleDescriptor abstractWorkflowModuleDescriptor : moduleDescriptors) {
            if (!abstractWorkflowModuleDescriptor.getImplementationClass().getName().equals(className)) continue;
            return abstractWorkflowModuleDescriptor;
        }
        return null;
    }

    protected void setupWorkflowDescriptorParams(Map parameters) {
        this.descriptorParams = new HashMap(parameters);
        this.removeKeyOrAddError(this.descriptorParams, "workflowName", "admin.errors.workflows.cannot.find.name");
        this.removeKeyOrAddError(this.descriptorParams, "workflowStep", "admin.errors.workflows.cannot.find.step");
        this.removeKeyOrAddError(this.descriptorParams, "workflowTransition", "admin.errors.workflows.cannot.find.transition");
        this.removeKeyOrAddError(this.descriptorParams, "count", "admin.errors.workflows.cannot.find.count");
        this.descriptorParams.remove("Update");
    }

    public String getDescriptorHtml() {
        if (this.workflowModuleDescriptor != null) {
            return this.workflowModuleDescriptor.getHtml("edit-parameters", this.workflowDescriptor);
        }
        return null;
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    protected int getIndexCount() {
        String[] counts = StringUtils.split((String)this.getCount(), (String)".");
        return Integer.parseInt(counts[counts.length - 1]);
    }

    protected void setWorkflowDescriptor(AbstractDescriptor workflowDescriptor) {
        this.workflowDescriptor = workflowDescriptor;
    }

    protected Map getDescriptorParams() {
        return this.descriptorParams;
    }

    protected AbstractWorkflowModuleDescriptor getDescriptor() {
        return this.workflowModuleDescriptor;
    }

    protected abstract void setupWorkflowDescriptor();

    public abstract String getWorkflowDescriptorName();

    protected abstract String getPluginType();

    protected abstract void editWorkflowDescriptor(AbstractDescriptor var1, Map var2);
}

