/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.linking;

import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

@WebSudoRequired
public class EditLinkType
extends JiraWebActionSupport {
    Long id;
    String name;
    String outward;
    String inward;
    private IssueLinkType linkType;
    private final IssueLinkTypeManager issueLinkTypeManager;

    public EditLinkType(IssueLinkTypeManager issueLinkTypeManager) {
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    public String doDefault() throws Exception {
        this.name = this.getIssueLinkType().getName();
        this.outward = this.getIssueLinkType().getOutward();
        this.inward = this.getIssueLinkType().getInward();
        return super.doDefault();
    }

    public void doValidation() {
        if (this.name != null || this.outward != null || this.inward != null) {
            if (!TextUtils.stringSet((String)this.name)) {
                this.addError("name", this.getText("editlink.name.notspecified"));
            }
            if (!TextUtils.stringSet((String)this.outward)) {
                this.addError("outward", this.getText("editlink.outward.desc.notspecified"));
            }
            if (!TextUtils.stringSet((String)this.inward)) {
                this.addError("inward", this.getText("editlink.inward.desc.notspecified"));
            }
            if (this.name != null && this.duplicateLinkName()) {
                this.addError("name", this.getText("editlink.name.alreadyexists"));
            }
        }
        if (this.getIssueLinkType() == null) {
            this.addErrorMessage(this.getText("editlink.id.notfound", this.id));
        }
    }

    private boolean duplicateLinkName() {
        Collection existingIssueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(this.getName());
        if (existingIssueLinkTypes != null) {
            for (IssueLinkType issueLinkType : existingIssueLinkTypes) {
                if (this.id.equals(issueLinkType.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.issueLinkTypeManager.updateIssueLinkType(this.getIssueLinkType(), this.getName(), this.getOutward(), this.getInward());
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("ViewLinkTypes!default.jspa");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private IssueLinkType getIssueLinkType() {
        if (this.linkType == null) {
            this.linkType = this.issueLinkTypeManager.getIssueLinkType(this.id);
        }
        return this.linkType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOutward() {
        return this.outward;
    }

    public void setOutward(String outward) {
        this.outward = outward;
    }

    public String getInward() {
        return this.inward;
    }

    public void setInward(String inward) {
        this.inward = inward;
    }
}

