/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.util.JiraArrayUtils;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.ExecutableAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class ConfigureOptionScheme
extends AbstractManageIssueTypeOptionsAction
implements ExecutableAction {
    private String name;
    private String description;
    private String defaultOption;
    private String[] selectedOptions;
    private Long projectId;
    protected final ConstantsManager constantsManager;
    private static final String[] NO_OPTIONS = new String[0];

    public ConfigureOptionScheme(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, ConstantsManager constantsManager, IssueManager issueManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, issueManager);
        this.constantsManager = constantsManager;
    }

    public String doDefault() throws Exception {
        FieldConfigScheme configScheme = this.getConfigScheme();
        if (configScheme != null) {
            this.setName(configScheme.getName());
            this.setDescription(configScheme.getDescription());
            IssueType defaultValue = this.issueTypeSchemeManager.getDefaultValue(configScheme.getOneAndOnlyConfig());
            if (defaultValue != null) {
                this.setDefaultOption(defaultValue.getId());
            }
        }
        return "input";
    }

    public String doInput() {
        return "input";
    }

    public String doCopy() throws Exception {
        FieldConfigScheme configScheme = this.getConfigScheme();
        this.setName(this.getText("common.words.copyof", configScheme.getName()));
        this.setDescription(configScheme.getDescription());
        IssueType defaultValue = this.issueTypeSchemeManager.getDefaultValue(configScheme.getOneAndOnlyConfig());
        if (defaultValue != null) {
            this.setDefaultOption(defaultValue.getId());
        }
        Collection originalOptions = this.getOriginalOptions();
        String[] optionIds = new String[originalOptions.size()];
        int i = 0;
        for (Option option : originalOptions) {
            optionIds[i] = option.getId();
            ++i;
        }
        this.setSelectedOptions(optionIds);
        this.setSchemeId(null);
        this.setConfigScheme(null);
        return "input";
    }

    protected void doValidation() {
        if (StringUtils.isBlank((String)this.name)) {
            this.addError("name", this.getText("admin.common.errors.validname"));
        }
        if (this.selectedOptions == null || this.selectedOptions.length == 0) {
            this.addErrorMessage(this.getText("admin.errors.issuetypes.must.select.option"));
        } else {
            String fieldId = this.getManageableOption().getFieldId();
            for (String selectedOption : this.selectedOptions) {
                IssueConstant constant = this.constantsManager.getConstantObject(fieldId, selectedOption);
                if (constant != null) continue;
                this.addErrorMessage(this.getText("admin.errors.issuetypes.invalid.option.id", selectedOption));
            }
        }
        if (StringUtils.isNotBlank((String)this.getDefaultOption()) && !ArrayUtils.contains((Object[])this.getSelectedOptions(), (Object)this.getDefaultOption())) {
            this.addError("defaultOption", this.getText("admin.errors.issuetypes.default.option.must.be.in.selected"));
        }
    }

    protected String doExecute() throws Exception {
        FieldConfigScheme configScheme = this.executeUpdate();
        if (this.getProjectId() == null) {
            return this.getRedirect(configScheme);
        }
        String redirectUrl = "SelectIssueTypeSchemeForProject.jspa?&schemeId=" + configScheme.getId() + "&projectId=" + this.getProjectId() + "&atl_token=" + this.getXsrfToken();
        return this.forceRedirect(redirectUrl);
    }

    public void run() {
        this.executeUpdate();
    }

    private FieldConfigScheme executeUpdate() {
        LinkedHashSet<String> optionIds = new LinkedHashSet<String>(Arrays.asList(this.selectedOptions));
        FieldConfigScheme configScheme = this.getConfigScheme();
        if (configScheme.getId() == null) {
            configScheme = this.issueTypeSchemeManager.create(this.name, this.description, new ArrayList<String>(optionIds));
            this.issueTypeSchemeManager.setDefaultValue(configScheme.getOneAndOnlyConfig(), this.getDefaultOption());
            this.log.info((Object)("Config scheme '" + configScheme.getName() + "' created successfully. "));
        } else {
            configScheme = this.issueTypeSchemeManager.update(new FieldConfigScheme.Builder(configScheme).setName(this.name).setDescription(this.description).toFieldConfigScheme(), optionIds);
            this.issueTypeSchemeManager.setDefaultValue(configScheme.getOneAndOnlyConfig(), this.getDefaultOption());
        }
        return configScheme;
    }

    public Collection getOptionsForScheme() {
        String[] selectedOptions = this.getSelectedOptions();
        if (selectedOptions != null) {
            return this.getNewOptions();
        }
        return this.getOriginalOptions();
    }

    public boolean isAllowEditOptions() {
        return true;
    }

    public Collection getAvailableOptions() {
        return CollectionUtils.subtract(this.getAllOptions(), (Collection)this.getOptionsForScheme());
    }

    public Collection<?> getAllOptions() {
        Collection constants = this.constantsManager.getConstantObjects(this.getManageableOption().getFieldId());
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)constants, (Function)new Function<Object, IssueConstantOption>(){

            public IssueConstantOption apply(@Nullable Object input) {
                return new IssueConstantOption((IssueConstant)input);
            }
        }));
    }

    public long getMaxHeight() {
        Collection constantObjects = this.constantsManager.getConstantObjects(this.getManageableOption().getFieldId());
        if (constantObjects != null && !constantObjects.isEmpty()) {
            return 23L * (long)constantObjects.size();
        }
        return 23L;
    }

    @Override
    public FieldConfigScheme getConfigScheme() {
        if (this.configScheme == null) {
            this.configScheme = this.schemeId != null ? this.configSchemeManager.getFieldConfigScheme(this.schemeId) : new FieldConfigScheme.Builder().setName(this.name).setDescription(this.description).setFieldId(this.fieldId).toFieldConfigScheme();
        }
        return this.configScheme;
    }

    public GenericValue getProject() {
        return this.getProjectManager().getProject(this.getProjectId());
    }

    public Collection getTargetOptions() {
        ArrayList<String> optionIds = new ArrayList<String>(Arrays.asList(this.getSelectedOptions()));
        return CollectionUtils.collect(optionIds, (Transformer)new Transformer(){
            String fieldId;
            {
                this.fieldId = ConfigureOptionScheme.this.getManageableOption().getFieldId();
            }

            public Object transform(Object input) {
                String id = (String)input;
                return new IssueConstantOption(ConfigureOptionScheme.this.constantsManager.getConstantObject(this.fieldId, id));
            }
        });
    }

    protected Collection getNewOptions() {
        String[] selectedOptions = this.getSelectedOptions();
        ArrayList<IssueConstantOption> selectedOptionsList = new ArrayList<IssueConstantOption>();
        for (String selectedOption : selectedOptions) {
            IssueConstant constantObject = this.constantsManager.getConstantObject(this.getManageableOption().getFieldId(), selectedOption);
            selectedOptionsList.add(new IssueConstantOption(constantObject));
        }
        return selectedOptionsList;
    }

    protected Collection getOriginalOptions() {
        FieldConfigScheme configScheme = this.getConfigScheme();
        FieldConfig config = configScheme.getOneAndOnlyConfig();
        if (config != null) {
            return this.optionSetManager.getOptionsForConfig(config).getOptions();
        }
        return Collections.EMPTY_LIST;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultOption() {
        return this.defaultOption;
    }

    public void setDefaultOption(String defaultOption) {
        this.defaultOption = defaultOption;
    }

    public String[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(String[] selectedOptions) {
        this.selectedOptions = JiraArrayUtils.isContainsOneBlank(selectedOptions) ? NO_OPTIONS : selectedOptions;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
}

