/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.configuration;

import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class AddFieldConfiguration
extends JiraWebActionSupport {
    private String fieldLayoutName;
    private String fieldLayoutDescription;
    private final FieldLayoutManager fieldLayoutManager;
    private List<EditableFieldLayout> editableFieldLayouts;

    public AddFieldConfiguration(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public String doDefault() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.getFieldLayoutName())) {
            this.addError("fieldLayoutName", this.getText("admin.errors.empty.field.configuration.name"));
            return "error";
        }
        if (!this.invalidInput()) {
            for (EditableFieldLayout fieldLayout : this.getFieldLayouts()) {
                if (!this.getFieldLayoutName().equals(fieldLayout.getName())) continue;
                this.addError("fieldLayoutName", this.getText("admin.errors.fieldlayout.name.exists"));
                return "error";
            }
        }
        EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
        EditableFieldLayoutImpl editableFieldLayout = new EditableFieldLayoutImpl(null, editableDefaultFieldLayout.getFieldLayoutItems());
        editableFieldLayout.setName(this.getFieldLayoutName());
        editableFieldLayout.setDescription(this.getFieldLayoutDescription());
        EditableFieldLayout newLayout = this.fieldLayoutManager.storeAndReturnEditableFieldLayout((EditableFieldLayout)editableFieldLayout);
        return this.returnCompleteWithInlineRedirect(String.format("ConfigureFieldLayout!default.jspa?id=%d", newLayout.getId()));
    }

    public List<EditableFieldLayout> getFieldLayouts() {
        if (this.editableFieldLayouts == null) {
            this.editableFieldLayouts = this.fieldLayoutManager.getEditableFieldLayouts();
        }
        return this.editableFieldLayouts;
    }

    public String getFieldLayoutName() {
        return this.fieldLayoutName;
    }

    public void setFieldLayoutName(String fieldLayoutName) {
        this.fieldLayoutName = fieldLayoutName;
    }

    public String getFieldLayoutDescription() {
        return this.fieldLayoutDescription;
    }

    public void setFieldLayoutDescription(String fieldLayoutDescription) {
        this.fieldLayoutDescription = fieldLayoutDescription;
    }
}

