/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayout;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.web.action.AbstractViewIssueColumns;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@WebSudoRequired
public class ViewIssueColumns
extends AbstractViewIssueColumns {
    private EditableDefaultColumnLayout editableDefaultColumnLayout;
    private final ApplicationProperties applicationProperties;
    private final UserPreferencesManager userPreferencesManager;

    public ViewIssueColumns(IssueSearcherManager issueSearcherManager, ApplicationProperties applicationProperties, UserPreferencesManager userPreferencesManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.applicationProperties = applicationProperties;
        this.userPreferencesManager = userPreferencesManager;
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() != null && this.getPermissionManager().hasPermission(0, this.getLoggedInUser())) {
            return this.runOperation();
        }
        return "securitybreach";
    }

    @Override
    public String getActionLocation(String prefix) {
        return prefix + "admin/" + this.getActionName() + ".jspa";
    }

    @Override
    protected List<NavigableField> getAvailableNavigatableFields() throws FieldException {
        return new ArrayList<NavigableField>(this.getFieldManager().getAllAvailableNavigableFields());
    }

    @Override
    protected EditableColumnLayout getColumnLayout() {
        if (this.editableDefaultColumnLayout == null) {
            try {
                this.editableDefaultColumnLayout = this.getColumnLayoutManager().getEditableDefaultColumnLayout();
            }
            catch (ColumnLayoutStorageException e) {
                this.log.error((Object)"Error while retrieving column layout.", (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.error.retrieving.column.layout"));
            }
        }
        return this.editableDefaultColumnLayout;
    }

    @Override
    protected void store() {
        try {
            this.getColumnLayoutManager().storeEditableDefaultColumnLayout((EditableDefaultColumnLayout)this.getColumnLayout());
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)"The was an error storing the default column layout.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.error.storing.column.layout"));
        }
    }

    public boolean isUsingDefaultColumns() {
        try {
            return !this.getColumnLayoutManager().hasDefaultColumnLayout();
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.not.check.column.layout.default"));
            return true;
        }
    }

    public List<ColumnLayoutItem> getDefaultColumns() {
        try {
            return this.getColumnLayoutManager().getDefaultColumnLayout().getColumnLayoutItems();
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.not.retrieve.column.layout"));
            return Collections.emptyList();
        }
    }

    @Override
    protected String doRestoreDefault() {
        try {
            this.getColumnLayoutManager().restoreDefaultColumnLayout();
        }
        catch (ColumnLayoutStorageException e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.could.not.restore.system.default"));
        }
        return this.getResult();
    }

    public Boolean isActionsAndOperationsShowing() {
        return this.applicationProperties.getOption("user.show.actions.in.navigator");
    }

    @Override
    public String doShowActionsColumn() {
        this.applicationProperties.setOption("user.show.actions.in.navigator", true);
        this.userPreferencesManager.clearCache();
        return "input";
    }

    @Override
    public String doHideActionsColumn() {
        this.applicationProperties.setOption("user.show.actions.in.navigator", false);
        this.userPreferencesManager.clearCache();
        return "input";
    }
}

