/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServletRequest;

@Immutable
public class HttpRequestLocal<T> {
    private final String name;

    public HttpRequestLocal(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public T get() {
        return this.ifRequestAvailable(new RequestOperation<T>(){

            @Override
            public T doInRequest(HttpServletRequest request) {
                Object value = request.getAttribute(HttpRequestLocal.this.name);
                if (value == null) {
                    value = HttpRequestLocal.this.initialValue();
                    request.setAttribute(HttpRequestLocal.this.name, value);
                }
                return value;
            }
        });
    }

    public void set(final T value) {
        this.ifRequestAvailable(new RequestOperation<Void>(){

            @Override
            public Void doInRequest(HttpServletRequest request) {
                request.setAttribute(HttpRequestLocal.this.name, value);
                return null;
            }
        });
    }

    public void remove() {
        this.ifRequestAvailable(new RequestOperation<Void>(){

            @Override
            public Void doInRequest(HttpServletRequest request) {
                request.removeAttribute(HttpRequestLocal.this.name);
                return null;
            }
        });
    }

    protected T initialValue() {
        return null;
    }

    private <T> T ifRequestAvailable(RequestOperation<T> requestOperation) {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null) {
            return requestOperation.doInRequest(request);
        }
        return null;
    }

    private static interface RequestOperation<T> {
        public T doInRequest(HttpServletRequest var1);
    }
}

