/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class CompositeIndexLifecycleManager
implements IndexLifecycleManager {
    private static final Logger log = Logger.getLogger(CompositeIndexLifecycleManager.class);
    private final IndexLifecycleManager[] delegates;
    private final AtomicBoolean previousReindexFailed = new AtomicBoolean();

    public CompositeIndexLifecycleManager(IssueIndexManager issueIndexManager, SharedEntityIndexManager sharedEntityIndexManager) {
        this.delegates = new IndexLifecycleManager[]{issueIndexManager, sharedEntityIndexManager};
    }

    public long optimize() {
        log.info((Object)"Optimize Indexes starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            long optimize = delegate.optimize();
            log.info((Object)("Optimize took: " + optimize + "ms. Indexer: " + delegate.toString()));
            result += optimize;
        }
        log.info((Object)("Optimize Indexes complete. Total time: " + result + "ms."));
        return result;
    }

    public long reIndexAll(Context context) {
        log.info((Object)"Reindex All starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            try {
                long reIndexAll = delegate.reIndexAll(context);
                log.info((Object)("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString()));
                result += reIndexAll;
            }
            catch (RuntimeException re) {
                this.previousReindexFailed.set(true);
                log.error((Object)("Reindex All FAILED.  Indexer: " + delegate.toString()), (Throwable)re);
                throw re;
            }
        }
        context.setName("");
        log.info((Object)("Reindex All complete. Total time: " + result + "ms."));
        this.previousReindexFailed.set(false);
        return result;
    }

    public long reIndexAllIssuesInBackground(Context context) {
        log.info((Object)"Reindex All In Background starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            long checkpoint = System.currentTimeMillis();
            try {
                long reIndexAll = delegate.reIndexAllIssuesInBackground(context);
                log.info((Object)("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString()));
                result += reIndexAll;
            }
            catch (RuntimeException re) {
                this.previousReindexFailed.set(true);
                log.error((Object)("Reindex All In Background FAILED. Indexer: " + delegate.toString()), (Throwable)re);
                throw re;
            }
        }
        context.setName("");
        log.info((Object)("Reindex All In Background complete. Total time: " + result + "ms."));
        return result;
    }

    public void shutdown() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.shutdown();
        }
    }

    public long activate(Context context) {
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.activate(context);
        }
        return result;
    }

    public void deactivate() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.deactivate();
        }
    }

    public boolean isIndexingEnabled() {
        return this.delegates[0].isIndexingEnabled();
    }

    public boolean isIndexConsistent() {
        if (this.previousReindexFailed.get()) {
            return false;
        }
        for (IndexLifecycleManager delegate : this.delegates) {
            if (delegate.isIndexConsistent()) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList result = new ArrayList();
        for (IndexLifecycleManager delegate : this.delegates) {
            result.addAll(delegate.getAllIndexPaths());
        }
        return Collections.unmodifiableCollection(result);
    }

    public int size() {
        int result = 0;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.size();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

