/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.JqlDateSupportImpl;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.upgrade.tasks.jql.AbstractDateXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.JqlXmlSupport;
import com.atlassian.jira.util.dbc.Assertions;
import electric.xml.Element;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class AbsoluteDateXmlHandler
extends AbstractDateXmlHandler {
    private static final Logger log = Logger.getLogger(AbsoluteDateXmlHandler.class);
    private static final String ELEMENT_FROM_DATE = "fromDate";
    private static final String ELEMENT_TO_DATE = "toDate";
    private final JqlDateSupport dateSupport;

    public AbsoluteDateXmlHandler(Collection<String> supportedXmlFieldNames, TimeZoneManager timeZoneManager) {
        this(supportedXmlFieldNames, new JqlDateSupportImpl(timeZoneManager));
    }

    AbsoluteDateXmlHandler(Collection<String> supportedXmlFieldNames, JqlDateSupport dateSupport) {
        super(supportedXmlFieldNames);
        this.dateSupport = (JqlDateSupport)Assertions.notNull((String)"dateSupport", (Object)dateSupport);
    }

    @Override
    protected String getLowerBound(String fieldName, Element element) {
        return this.getBound(fieldName, element, ELEMENT_FROM_DATE);
    }

    @Override
    protected String getUpperBound(String fieldName, Element element) {
        return this.getBound(fieldName, element, ELEMENT_TO_DATE);
    }

    private String getBound(String fieldName, Element element, String subElement) {
        String dateString = JqlXmlSupport.getTextFromSubElement(element, subElement);
        if (dateString != null) {
            try {
                long dateLong = Long.parseLong(dateString);
                return this.dateSupport.getDateString(new Date(dateLong));
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Date parameter '%s' in element '%s' is and invalid date for field '%s'.", dateString, subElement, fieldName));
            }
        }
        return null;
    }
}

