/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpgradeTask_Build601
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build601.class);
    private static final String JIRA_OPTION_USER_PASSWORD_EXTERNALMGT = "jira.option.user.externalpasswordmanagement";
    private static final String DEFAULT_DIRECTORY = "JIRA Internal Directory";
    private static final String DELEGATING_DIRECTORY = "JIRA Delegated Authentication Directory";
    private static final String CROWD_DIRECTORY = "Remote Crowd Directory";
    private static final String APPLICATION_ENTITY_NAME = "Application";
    private static final String DIRECTORY_ENTITY_NAME = "Directory";
    private static final int INTERNAL_DIRECTORY_ID = 1;
    private static final int REMOTE_CROWD_DIRECTORY_ID = 2;
    private static final int DELEGATED_LDAP_DIRECTORY_ID = 3;
    private static final String DIRECTORY_OPERATION_ENTITY_NAME = "DirectoryOperation";
    private static final String DIRECTORY_ATTRIBUTE_ENTITY_NAME = "DirectoryAttribute";
    private final CrowdDirectoryService crowdDirectoryService;
    private final LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader;
    private final ApplicationProperties applicationProperties;
    private final String upgradeGuideUrl;
    private final String upgradeGuideTitle;
    private int ofbizProviderCount;
    private int crowdProviderCount;
    private int ldapProviderCount;
    private int unknownProviderCount;
    private List<String> providerList;
    private GenericDelegator genericDelegator;
    private static final Set<String> ofbizProviders = CollectionBuilder.newBuilder((Object[])new String[]{"com.atlassian.core.ofbiz.osuser.CoreOFBizCredentialsProvider", "com.atlassian.jira.user.osuser.JiraOFBizProfileProvider", "com.atlassian.jira.user.osuser.JiraOFBizAccessProvider", "com.opensymphony.user.provider.ofbiz.OFBizAccessProvider", "com.opensymphony.user.provider.ofbiz.OFBizProfileProvider", "com.opensymphony.user.provider.ofbiz.OFBizCredentialsProvider"}).asSet();
    private static final Set<String> crowdProviders = CollectionBuilder.newBuilder((Object[])new String[]{"com.atlassian.crowd.integration.osuser.CrowdCredentialsProvider", "com.atlassian.crowd.integration.osuser.CrowdAccessProvider", "com.atlassian.crowd.integration.osuser.DelegatingProfileProvider"}).asSet();
    private static final Set<String> ldapProviders = CollectionBuilder.newBuilder((Object[])new String[]{"com.opensymphony.user.provider.ldap.LDAPCredentialsProvider"}).asSet();
    private static final String CROWD_EMBEDDED_APPLICATION = "crowd-embedded";

    public UpgradeTask_Build601(GenericDelegator genericDelegator, CrowdDirectoryService crowdDirectoryService, LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader, ApplicationProperties applicationProperties) {
        super(false);
        this.genericDelegator = genericDelegator;
        this.crowdDirectoryService = crowdDirectoryService;
        this.ldapDirectoryInstanceLoader = ldapDirectoryInstanceLoader;
        this.applicationProperties = applicationProperties;
        HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("upgrading");
        this.upgradeGuideUrl = helpPath.getUrl();
        this.upgradeGuideTitle = helpPath.getTitle();
    }

    @Override
    public String getBuildNumber() {
        return "601";
    }

    @Override
    public String getShortDescription() {
        return "Migrate User Directory configuration";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        DirectoryDao directoryDao;
        this.addJiraApplication();
        this.providerList = new ArrayList<String>();
        this.ofbizProviderCount = 0;
        this.crowdProviderCount = 0;
        this.ldapProviderCount = 0;
        InputStream osuserStream = this.getOSUserXmlStream();
        if (!this.validatePresentConfiguration(osuserStream)) {
            return;
        }
        Document document = null;
        boolean internalDirectory = false;
        boolean remoteCrowdDirectory = false;
        boolean ldapDirectory = false;
        if (osuserStream != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(osuserStream);
            this.extractConfigurationTypes(document);
            log.info((Object)"The following OSUser providers have been detected in the osuser.xml file.");
            for (String providerClassName : this.providerList) {
                log.info((Object)providerClassName);
            }
            if (this.unknownProviderCount > 0) {
                this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.bad.providers", this.upgradeGuideUrl, this.upgradeGuideTitle));
                return;
            }
            boolean oldConfigOK = false;
            if (this.ofbizProviderCount == 3 && this.crowdProviderCount == 0 && this.ldapProviderCount == 0) {
                oldConfigOK = true;
                internalDirectory = true;
            } else if (this.ofbizProviderCount == 0 && this.crowdProviderCount == 3 && this.ldapProviderCount == 0) {
                oldConfigOK = true;
                remoteCrowdDirectory = true;
            } else if (this.ofbizProviderCount == 3 && this.crowdProviderCount == 0 && this.ldapProviderCount >= 1) {
                oldConfigOK = true;
                ldapDirectory = true;
            }
            if (!oldConfigOK) {
                this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.bad.osuser.config", this.upgradeGuideUrl, this.upgradeGuideTitle));
                return;
            }
            log.info((Object)"Migrating a valid User Directory configuration found in osuser.xml");
        } else {
            internalDirectory = true;
        }
        if (internalDirectory) {
            this.createInternalDirectoryConfiguration(0);
        }
        if (remoteCrowdDirectory) {
            this.removeAllDirectories();
            this.createRemoteCrowdDirectoryConfiguration(0);
            this.createInternalDirectoryConfiguration(1);
        }
        if (ldapDirectory) {
            this.removeAllDirectories();
            this.createDelegatingLdpaDirectoryConfiguration(document, 0);
            this.createInternalDirectoryConfiguration(this.ldapProviderCount);
        }
        if ((directoryDao = ComponentManager.getComponentInstanceOfType(DirectoryDao.class)) instanceof OfBizDirectoryDao) {
            ((OfBizDirectoryDao)directoryDao).flushCache();
        } else {
            log.error((Object)("Expected to find an OfBizDirectoryDao, but got " + directoryDao.getClass().getName()));
        }
        if (this.getErrors().isEmpty() && ldapDirectory) {
            this.testLdapConnections();
        }
    }

    private void createInternalDirectoryConfiguration(int position) throws GenericEntityException {
        if (!this.genericDelegator.findByAnd(DIRECTORY_ENTITY_NAME, (Map)FieldMap.build((String)"directoryName", (Object)DEFAULT_DIRECTORY)).isEmpty()) {
            return;
        }
        this.addDirectory(1, DEFAULT_DIRECTORY, true, "JIRA default internal directory", InternalDirectory.class.getName(), DirectoryType.INTERNAL, position);
        this.addDirectoryOperations(1, Sets.newHashSet((Object[])OperationType.values()));
        this.addDirectoryAttribute(1, "user_encryption_method", "atlassian-security");
    }

    protected void addJiraApplication() throws GenericEntityException {
        if (!this.genericDelegator.findByAnd(APPLICATION_ENTITY_NAME, (Map)FieldMap.build((String)"name", (Object)CROWD_EMBEDDED_APPLICATION)).isEmpty()) {
            return;
        }
        FieldMap applicationFields = FieldMap.build((String)"id", (Object)1).add("name", (Object)CROWD_EMBEDDED_APPLICATION).add("lowerName", (Object)CROWD_EMBEDDED_APPLICATION.toLowerCase()).add("active", (Object)1).add("description", (Object)"").add("applicationType", (Object)"CROWD").add("credential", (Object)PasswordCredential.NONE.getCredential()).add("createdDate", (Object)new Timestamp(new Date().getTime())).add("updatedDate", (Object)new Timestamp(new Date().getTime()));
        try {
            this.genericDelegator.create(APPLICATION_ENTITY_NAME, (Map)applicationFields);
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addDirectory(int directoryId, String directory, boolean active, String description, String implementationClassName, DirectoryType directoryType, int position) {
        FieldMap directoryFields = FieldMap.build((String)"id", (Object)directoryId).add("directoryName", (Object)directory).add("lowerDirectoryName", (Object)directory.toLowerCase()).add("active", (Object)(active ? 1 : 0)).add("description", (Object)description).add("type", (Object)directoryType.name()).add("position", (Object)position).add("implementationClass", (Object)implementationClassName).add("lowerImplementationClass", (Object)implementationClassName.toLowerCase()).add("createdDate", (Object)new Timestamp(new Date().getTime())).add("updatedDate", (Object)new Timestamp(new Date().getTime()));
        try {
            this.genericDelegator.create(DIRECTORY_ENTITY_NAME, (Map)directoryFields);
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addDirectoryOperations(int directoryId, HashSet<OperationType> operationTypes) {
        for (OperationType operationType : operationTypes) {
            FieldMap directoryOperationFields = FieldMap.build((String)"directoryId", (Object)directoryId).add("operationType", (Object)operationType.getName());
            try {
                this.genericDelegator.create(DIRECTORY_OPERATION_ENTITY_NAME, (Map)directoryOperationFields);
            }
            catch (GenericEntityException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void addDirectoryAttribute(int directoryId, String attributeKey, String value) {
        FieldMap directoryAttributeFields = FieldMap.build((String)"directoryId", (Object)directoryId).add("name", (Object)attributeKey).add("value", (Object)value);
        try {
            this.genericDelegator.create(DIRECTORY_ATTRIBUTE_ENTITY_NAME, (Map)directoryAttributeFields);
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void createRemoteCrowdDirectoryConfiguration(int position) {
        boolean paramsOK;
        Properties crowdProperties = new Properties();
        InputStream crowdPropertyInputStream = this.getClass().getResourceAsStream("/crowd.properties");
        if (crowdPropertyInputStream == null) {
            throw new IllegalStateException("We found a Crowd Provider in the osuser.xml file to be migrated, but can't locate the 'crowd.properties' file.");
        }
        try {
            crowdProperties.load(crowdPropertyInputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("An error occurred while loading the 'crowd.properties' file for migrating the Crowd connection properties.", ex);
        }
        boolean bl = paramsOK = this.checkForRequiredCrowdParams(crowdProperties, "application.name") && this.checkForRequiredCrowdParams(crowdProperties, "application.password") && this.checkForRequiredCrowdParams(crowdProperties, "crowd.server.url");
        if (!paramsOK) {
            return;
        }
        this.addDirectory(2, CROWD_DIRECTORY, true, "Remote crowd directory", RemoteCrowdDirectory.class.getName(), DirectoryType.CROWD, position);
        this.addDirectoryOperations(2, Sets.newHashSet((Object[])OperationType.values()));
        String crowdServiceUrl = new CrowdServiceUrlBuilder().setPropertiesUrlTo((String)crowdProperties.get("crowd.server.url")).build();
        this.addDirectoryAttribute(2, "application.name", (String)crowdProperties.get("application.name"));
        this.addDirectoryAttribute(2, "application.password", (String)crowdProperties.get("application.password"));
        if (crowdServiceUrl != null) {
            this.addDirectoryAttribute(2, "crowd.server.url", crowdServiceUrl);
        }
        this.addDirectoryAttribute(2, "useNestedGroups", "true");
        log.warn((Object)"Added migrated directory to JIRA:Remote crowd directory");
    }

    private void createDelegatingLdpaDirectoryConfiguration(Document document, int position) throws GenericEntityException {
        int ldapIndex = 0;
        Element ldapProviderElement = null;
        NodeList providerElements = document.getElementsByTagName("provider");
        for (int i = 0; i < providerElements.getLength(); ++i) {
            Element providerElement = (Element)providerElements.item(i);
            String className = providerElement.getAttribute("class");
            if (!className.contains("com.opensymphony.user.provider.ldap.LDAPCredentialsProvider")) continue;
            ldapProviderElement = providerElement;
            this.addDelegatingLdapDirectory(3 + ldapIndex, position + ldapIndex, ldapProviderElement);
            ++ldapIndex;
        }
        if (ldapProviderElement == null) {
            throw new RuntimeException("We found an LDAP Provider, but now it isn't there anymore.  That just shouldn't happen");
        }
    }

    private void addDelegatingLdapDirectory(int directoryId, int position, Element ldapProviderElement) {
        boolean paramsOK;
        HashMap<String, String> oldParams = new HashMap<String, String>();
        NodeList paramAttributes = ldapProviderElement.getElementsByTagName("property");
        for (int i = 0; i < paramAttributes.getLength(); ++i) {
            Element param = (Element)paramAttributes.item(i);
            oldParams.put(param.getAttribute("name"), param.getTextContent());
        }
        boolean bl = paramsOK = this.checkForRequiredLdapParams(oldParams, "java.naming.provider.url") && this.checkForRequiredLdapParams(oldParams, "searchBase") && this.checkForRequiredLdapParams(oldParams, "uidSearchName");
        if (!paramsOK) {
            return;
        }
        this.addDirectory(directoryId, DELEGATING_DIRECTORY, true, "JIRA delegating internal directory", DelegatedAuthenticationDirectory.class.getName(), DirectoryType.DELEGATING, position);
        this.addDirectoryOperations(directoryId, Sets.newHashSet((Object[])OperationType.values()));
        this.addDirectoryAttribute(directoryId, "ldap.url", (String)oldParams.get("java.naming.provider.url"));
        this.addDirectoryAttribute(directoryId, "ldap.basedn", (String)oldParams.get("searchBase"));
        if (oldParams.containsKey("java.naming.security.principal")) {
            this.addDirectoryAttribute(directoryId, "ldap.userdn", (String)oldParams.get("java.naming.security.principal"));
        }
        if (oldParams.containsKey("java.naming.security.credentials")) {
            this.addDirectoryAttribute(directoryId, "ldap.password", (String)oldParams.get("java.naming.security.credentials"));
        }
        this.addDirectoryAttribute(directoryId, "ldap.user.username", (String)oldParams.get("uidSearchName"));
        this.addDirectoryAttribute(directoryId, "crowd.delegated.directory.type", GenericLDAP.class.getName());
        this.addDirectoryAttribute(directoryId, "crowd.delegated.directory.auto.create.user", String.valueOf(false));
        if (oldParams.containsKey("java.naming.referral") && "follow".equals(oldParams.get("java.naming.referral"))) {
            this.addDirectoryAttribute(directoryId, "ldap.referral", String.valueOf(true));
        }
        log.warn((Object)"Added directory to JIRA:JIRA delegating internal directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLdapConnections() throws DirectoryInstantiationException, SQLException {
        Connection connection = this.getDatabaseConnection();
        try {
            String selectSql = "select id, directory_type from " + this.convertToSchemaTableName("cwd_directory") + " order by directory_position";
            PreparedStatement selectStmt = connection.prepareStatement(selectSql);
            ResultSet rs = selectStmt.executeQuery();
            while (rs.next()) {
                String directoryType = rs.getString("directory_type");
                if (!directoryType.equals(DirectoryType.DELEGATING.toString())) continue;
                Directory delegatingDirectory = this.crowdDirectoryService.findDirectoryById(rs.getLong("id"));
                Directory ldap = this.getLdapVersionOfDirectory(delegatingDirectory);
                RemoteDirectory ldapAuthenticatingDirectory = this.ldapDirectoryInstanceLoader.getDirectory(ldap);
                try {
                    ldapAuthenticatingDirectory.findUserByName("dummy-name");
                }
                catch (UserNotFoundException e) {
                }
                catch (OperationFailedException e) {
                    String message = e.getMessage();
                    if (message.toLowerCase().contains("authenticat")) {
                        this.addError(this.getI18nBean().getText("admin.errors.upgrade.602.ldap.authentication.failed", e.getMessage()));
                        continue;
                    }
                    this.addError(this.getI18nBean().getText("admin.errors.upgrade.602.ldap.connection.failed", e.getMessage()));
                }
            }
        }
        finally {
            connection.close();
        }
    }

    private Directory getLdapVersionOfDirectory(Directory directory) {
        DirectoryImpl ldap = new DirectoryImpl(directory);
        String ldapClass = directory.getValue("crowd.delegated.directory.type");
        ldap.setImplementationClass(ldapClass);
        return ldap;
    }

    private void removeAllDirectories() throws GenericEntityException {
        this.genericDelegator.removeByAnd(DIRECTORY_ATTRIBUTE_ENTITY_NAME, new HashMap());
        this.genericDelegator.removeByAnd(DIRECTORY_OPERATION_ENTITY_NAME, new HashMap());
        this.genericDelegator.removeByAnd(DIRECTORY_ENTITY_NAME, new HashMap());
    }

    private boolean checkForRequiredCrowdParams(Properties oldParams, String s) {
        if (!oldParams.containsKey(s)) {
            this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.missing.crowd.param", s, this.upgradeGuideUrl, this.upgradeGuideTitle));
            return false;
        }
        return true;
    }

    private boolean checkForRequiredLdapParams(Map<String, String> oldParams, String s) {
        if (!oldParams.containsKey(s)) {
            this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.missing.ldap.param", s, this.upgradeGuideUrl, this.upgradeGuideTitle));
            return false;
        }
        return true;
    }

    private void extractConfigurationTypes(Document document) {
        NodeList providerElements = document.getElementsByTagName("provider");
        for (int i = 0; i < providerElements.getLength(); ++i) {
            Element providerElement = (Element)providerElements.item(i);
            String className = providerElement.getAttribute("class");
            if (className.contains("com.atlassian.jira.user.osuser")) {
                ++this.ofbizProviderCount;
            } else if (className.contains("com.atlassian.core.ofbiz.osuser")) {
                ++this.ofbizProviderCount;
            } else if (className.contains("com.opensymphony.user.provider.ofbiz")) {
                ++this.ofbizProviderCount;
            } else if (ofbizProviders.contains(className)) {
                ++this.ofbizProviderCount;
            } else if (crowdProviders.contains(className)) {
                ++this.crowdProviderCount;
            } else if (ldapProviders.contains(className)) {
                ++this.ldapProviderCount;
            } else {
                log.error((Object)("OSUser config file 'osuser.xml' contains an unknown provider '" + className + "'."));
                ++this.unknownProviderCount;
            }
            this.providerList.add(className);
        }
    }

    private boolean validatePresentConfiguration(InputStream osuserStream) throws SQLException {
        HelpUtil.HelpPath userManagementChangesHelpPath = HelpUtil.getInstance().getHelpPath("upgrade.note.43.usermanagement.changes");
        if (osuserStream != null) {
            return true;
        }
        if (this.areExternalUsersPresent()) {
            this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.missing.osuser.xml", userManagementChangesHelpPath.getUrl(), userManagementChangesHelpPath.getTitle()));
            return false;
        }
        if (this.isExternalUserManagement()) {
            this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.missing.extrenal.user.management", userManagementChangesHelpPath.getUrl(), userManagementChangesHelpPath.getTitle()));
            return false;
        }
        if (this.isExternalPasswordManagement()) {
            this.addError(this.getI18nBean().getText("admin.errors.upgrade.601.error.missing.extrenal.password.management", userManagementChangesHelpPath.getUrl(), userManagementChangesHelpPath.getTitle()));
            return false;
        }
        return true;
    }

    private boolean isExternalUserManagement() {
        return this.applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    private boolean isExternalPasswordManagement() {
        return this.applicationProperties.getOption(JIRA_OPTION_USER_PASSWORD_EXTERNALMGT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean areExternalUsersPresent() throws SQLException {
        Connection connection = this.getDatabaseConnection();
        try {
            boolean bl;
            String sql = "select count(*) from " + this.convertToSchemaTableName("external_entities");
            PreparedStatement ps = connection.prepareStatement(sql);
            try {
                ResultSet rs = ps.executeQuery();
                rs.next();
                bl = rs.getInt(1) > 1;
            }
            catch (Throwable throwable) {
                ps.close();
                throw throwable;
            }
            ps.close();
            return bl;
        }
        finally {
            connection.close();
        }
    }

    protected InputStream getOSUserXmlStream() {
        return UpgradeTask_Build601.class.getResourceAsStream("/osuser.xml");
    }

    @VisibleForTesting
    static class CrowdServiceUrlBuilder {
        private String serviceUrlFromProperties;

        CrowdServiceUrlBuilder() {
        }

        CrowdServiceUrlBuilder setPropertiesUrlTo(String propertiesUrl) {
            this.serviceUrlFromProperties = propertiesUrl;
            return this;
        }

        String build() {
            if (this.serviceUrlFromProperties.endsWith("/services/")) {
                return StringUtils.removeEnd((String)this.serviceUrlFromProperties, (String)"/services/");
            }
            return StringUtils.removeEnd((String)this.serviceUrlFromProperties, (String)"/services");
        }
    }
}

