/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.template.Template;
import com.atlassian.jira.template.TemplateManager;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;

@SuppressWarnings(value={"MT_CORRECTNESS"}, justification="TODO Needs to be fixed")
public class DefaultTemplateManager
implements TemplateManager {
    private static final Logger log = Logger.getLogger(DefaultTemplateManager.class);
    private final ApplicationProperties applicationProperties;
    private final EventTypeManager eventTypeManager;
    private static final String templateIDMappingConfigFile = "email-template-id-mappings.xml";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private Map templatesMap;
    private Map templateFileMap;

    public DefaultTemplateManager(ApplicationProperties applicationProperties, EventTypeManager eventTypeManager) {
        this.applicationProperties = applicationProperties;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public Template getTemplate(Long templateId) {
        if (this.templatesMap == null) {
            this.getAllTemplatesMap();
        }
        return (Template)this.templatesMap.get(templateId);
    }

    @Override
    public Template getTemplate(SchemeEntity notificationSchemeEntity) {
        Template template;
        Long templateId = (Long)notificationSchemeEntity.getTemplateId();
        if (templateId == null) {
            Long eventTypeId = (Long)notificationSchemeEntity.getEntityTypeId();
            EventType eventType = this.eventTypeManager.getEventType(eventTypeId);
            if (eventTypeId == null || eventType == null) {
                log.error((Object)("Unable to determine the email template for the notification scheme entity : " + notificationSchemeEntity.getId() + "."));
                throw new DataAccessException("Unable to determine the email template for the notification scheme entity : " + notificationSchemeEntity.getId() + ".");
            }
            template = this.getDefaultTemplate(eventType);
        } else {
            template = this.getTemplate(templateId);
        }
        return template;
    }

    public Template getDefaultTemplate(EventType eventType) {
        return this.getTemplate(eventType.getTemplateId());
    }

    private Collection getAllTemplates() {
        return new ArrayList(this.getAllTemplatesMap().values());
    }

    @Override
    public Map getTemplatesMap(String type) {
        ConcurrentHashMap<Long, Template> templatesOfType = new ConcurrentHashMap<Long, Template>();
        Collection allTemplates = this.getAllTemplates();
        for (Template template : allTemplates) {
            if (type == null || !type.equals(template.getType())) continue;
            templatesOfType.put(template.getId(), template);
        }
        return templatesOfType;
    }

    private synchronized Map getAllTemplatesMap() {
        if (this.templatesMap == null) {
            this.initTemplates();
        }
        return this.templatesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTemplateContent(Long templateId, String format) {
        String templateContent = null;
        String templateFileName = this.getTemplateFilename(templateId);
        String resourceName = EMAIL_TEMPLATES + format + "/" + templateFileName;
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new InputStreamReader(ClassLoaderUtils.getResourceAsStream((String)resourceName, this.getClass()), this.applicationProperties.getString("webwork.i18n.encoding")));
            StringWriter stringWriter = new StringWriter();
            char[] buf = new char[1024];
            while ((len = reader.read(buf, 0, 1024)) != -1) {
                stringWriter.write(buf, 0, len);
            }
            templateContent = stringWriter.toString();
        }
        catch (Exception e) {
            log.error((Object)("Problem retrieving template [" + resourceName + "]"), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Could not close the file '" + resourceName + "'."));
            }
        }
        return templateContent;
    }

    private String getTemplateFilename(Long templateId) {
        if (this.templateFileMap == null) {
            this.getAllTemplates();
        }
        return (String)this.templateFileMap.get(templateId);
    }

    private void initTemplates() {
        this.templatesMap = new ListOrderedMap();
        this.templateFileMap = new HashMap();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)templateIDMappingConfigFile, DefaultTemplateManager.class);
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("templatemapping");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                Long id = new Long(action.getAttributeValue("id"));
                String name = action.getElement("name").getTextString();
                String templateFile = action.getElement("template").getTextString();
                String templateType = action.getElement("templatetype").getTextString();
                Template template = new Template(id, name, null, null, null, templateType);
                this.templatesMap.put(id, template);
                this.templateFileMap.put(id, templateFile);
            }
        }
        catch (ParseException e) {
            log.error((Object)("Error parsing email-template-id-mappings.xml: " + (Object)((Object)e)), (Throwable)e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn((Object)"Could not close template id mappings inputStream.", (Throwable)e);
        }
    }
}

