/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.studio.startup;

import com.atlassian.jira.studio.startup.JiraDefaultLocator;
import com.atlassian.jira.studio.startup.Locator;
import com.atlassian.jira.studio.startup.ServiceLocator;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import com.atlassian.jira.studio.startup.SystemPropertyLocator;
import com.atlassian.util.concurrent.LazyReference;
import javax.annotation.Nonnull;

public final class StudioStartupHooksLocator {
    private static LazyReference<StudioStartupHooks> ref = new LazyReference<StudioStartupHooks>(){
        private final Locator[] LOCATORS = new Locator[]{new SystemPropertyLocator(), new ServiceLocator(), new JiraDefaultLocator()};

        @Nonnull
        protected StudioStartupHooks create() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = StudioStartupHooksLocator.class.getClassLoader();
            }
            for (Locator locator : this.LOCATORS) {
                StudioStartupHooks hooks = locator.locate(classLoader);
                if (hooks == null) continue;
                return hooks;
            }
            throw new IllegalStateException("Unable to find StudioStartupHooks.");
        }
    };

    private StudioStartupHooksLocator() {
    }

    public static StudioStartupHooks getStudioStartupHooks() {
        return (StudioStartupHooks)ref.get();
    }
}

