/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.ServiceTypes;
import com.atlassian.jira.user.util.Users;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;

public class DefaultServiceTypes
implements ServiceTypes {
    private final InBuiltServiceTypes inBuiltServiceTypes;
    private final PermissionManager permissionManager;

    public DefaultServiceTypes(InBuiltServiceTypes inBuiltServiceTypes, PermissionManager permissionManager) {
        this.inBuiltServiceTypes = inBuiltServiceTypes;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean isCustom(String serviceClassName) {
        return !this.isInBuilt(serviceClassName);
    }

    @Override
    public boolean isInBuilt(String serviceClassName) {
        return Iterables.any(this.inBuiltServiceTypes.all(), (Predicate)new MatchByServiceClassNamePredicate(serviceClassName));
    }

    @Override
    public boolean isManageableBy(User user, String serviceClassName) {
        if (this.isCustom(serviceClassName)) {
            if (Users.isAnonymous((User)user)) {
                return false;
            }
            return this.permissionManager.hasPermission(44, user);
        }
        if (this.isInBuilt(serviceClassName)) {
            return Iterables.any(this.inBuiltServiceTypes.manageableBy(user), (Predicate)new MatchByServiceClassNamePredicate(serviceClassName));
        }
        return false;
    }

    private static class MatchByServiceClassNamePredicate
    implements Predicate<InBuiltServiceTypes.InBuiltServiceType> {
        private final String serviceClassName;

        public MatchByServiceClassNamePredicate(String serviceClassName) {
            this.serviceClassName = serviceClassName;
        }

        public boolean apply(@Nullable InBuiltServiceTypes.InBuiltServiceType anInBuiltServiceType) {
            return anInBuiltServiceType.getType().getName().equals(this.serviceClassName);
        }
    }
}

