/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.type.SimpleIssueFieldSecurityType;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class CurrentAssigneeHasAssignablePermission
extends SimpleIssueFieldSecurityType {
    private JiraAuthenticationContext authenticationContext;

    public CurrentAssigneeHasAssignablePermission(JiraAuthenticationContext jiraAuthenticationContext) {
        this.authenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.authenticationContext.getI18nHelper().getText("admin.permission.types.current.assignee.has.assignable.perm");
    }

    @Override
    public String getType() {
        return "assigneeassignable";
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    protected String getFieldName() {
        return "issue_assignee";
    }

    @Override
    public boolean isValidForPermission(int permissionId) {
        return permissionId != 17;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, GenericValue project) {
        return this.getPermissionManager().hasPermission(17, project, user, issueCreation);
    }

    PermissionManager getPermissionManager() {
        return ComponentAccessor.getPermissionManager();
    }

    @Override
    protected String getField() {
        return "assignee";
    }
}

