/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.ofbiz.PagedDatabaseIterable;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizPortalPageStore
implements PortalPageStore {
    private static final List<String> DEFAULT_ORDER_BY_CLAUSE = Collections.singletonList("pagename ASC");
    private final OfBizDelegator delegator;
    private final Resolver<GenericValue, PortalPage> portalPageResolver = new Resolver<GenericValue, PortalPage>(){

        public PortalPage get(GenericValue input) {
            return OfBizPortalPageStore.this.gvToPortalPage(input);
        }
    };

    public OfBizPortalPageStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public EnclosedIterable<PortalPage> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        Resolver<PortalPage, Long> keyResolver = descriptor.preserveOrder() ? new Resolver<PortalPage, Long>(){

            public Long get(PortalPage input) {
                return input.getId();
            }
        } : null;
        return new PagedDatabaseIterable<PortalPage, Long>(descriptor.getIds(), (Resolver)keyResolver){

            @Override
            protected OfBizListIterator createListIterator(List<Long> ids) {
                return OfBizPortalPageStore.this.delegator.findListIteratorByCondition(Table.NAME, (EntityCondition)new EntityExpr("id", EntityOperator.IN, ids));
            }

            @Override
            protected Resolver<GenericValue, PortalPage> getResolver() {
                return OfBizPortalPageStore.this.portalPageResolver;
            }
        };
    }

    @Override
    public EnclosedIterable<PortalPage> getAll() {
        try {
            return new DatabaseIterable<PortalPage>(new Long(this.delegator.getCount(Table.NAME)).intValue(), this.portalPageResolver){

                @Override
                protected OfBizListIterator createListIterator() {
                    return OfBizPortalPageStore.this.delegator.findListIteratorByCondition(Table.NAME, null);
                }
            };
        }
        catch (DataAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(User owner) {
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"owner.username", (Object)owner.getName());
        List gvs = this.delegator.findByAnd(Table.NAME, EasyMap.build((Object)"username", (Object)this.getUserKey(owner.getName())), DEFAULT_ORDER_BY_CLAUSE);
        return this.gvToPortalPages(gvs);
    }

    @Override
    public PortalPage getPortalPageByOwnerAndName(User owner, String name) {
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"owner.username", (Object)owner.getName());
        GenericValue pageGV = EntityUtil.getOnly((List)this.delegator.findByAnd(Table.NAME, EasyMap.build((Object)"username", (Object)this.getUserKey(owner.getName()), (Object)"pagename", (Object)name), DEFAULT_ORDER_BY_CLAUSE));
        return this.gvToPortalPage(pageGV);
    }

    @Override
    public PortalPage getPortalPage(Long portalPageId) {
        GenericValue gv = this.findByPrimaryKey(portalPageId);
        return this.gvToPortalPage(gv);
    }

    @Override
    public PortalPage update(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        if (!portalPage.isSystemDefaultPortalPage()) {
            Assertions.notNull((String)"portalPage.owner.username", (Object)portalPage.getOwnerUserName());
        }
        GenericValue gv = this.findByPrimaryKey(portalPage.getId());
        gv.setString("pagename", portalPage.getName());
        gv.setString("description", portalPage.getDescription());
        if (!portalPage.isSystemDefaultPortalPage()) {
            gv.setString("username", this.getUserKey(portalPage.getOwnerUserName()));
        } else {
            gv.remove((Object)"username");
        }
        gv.remove((Object)"favCount");
        gv.setString("layout", portalPage.getLayout().name());
        this.delegator.store(gv);
        return this.getPortalPage(portalPage.getId());
    }

    @Override
    public PortalPage adjustFavouriteCount(SharedEntity portalPage, int incrementValue) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        GenericValue gv = this.findByPrimaryKey(portalPage.getId());
        Long currentFavcount = gv.getLong("favCount");
        long newFavcount = currentFavcount == null ? 0L : currentFavcount;
        if ((newFavcount += (long)incrementValue) < 0L) {
            newFavcount = 0L;
        }
        gv.set("favCount", (Object)newFavcount);
        this.delegator.store(gv);
        return this.getPortalPage(portalPage.getId());
    }

    @Override
    public PortalPage create(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.name", (Object)portalPage.getName());
        Assertions.notNull((String)"portalPage.owner.name", (Object)portalPage.getOwnerUserName());
        GenericValue gv = this.delegator.createValue(Table.NAME, MapBuilder.newBuilder().add((Object)"pagename", (Object)portalPage.getName()).add((Object)"description", (Object)portalPage.getDescription()).add((Object)"username", (Object)this.getUserKey(portalPage.getOwnerUserName())).add((Object)"favCount", (Object)0L).add((Object)"layout", (Object)portalPage.getLayout().name()).add((Object)"version", (Object)0L).toMap());
        return this.gvToPortalPage(gv);
    }

    @Override
    public void delete(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        this.delegator.removeByAnd(Table.NAME, EasyMap.build((Object)"id", (Object)portalPageId));
    }

    @Override
    public PortalPage getSystemDefaultPortalPage() {
        GenericValue gv = EntityUtil.getOnly((List)this.delegator.findByAnd("PortalPage", EasyMap.build((Object)"username", null)));
        if (gv == null) {
            return null;
        }
        return this.gvToPortalPage(gv);
    }

    @Override
    public boolean updatePortalPageOptimisticLock(Long portalPageId, Long currentVersion) {
        Long newVersion = currentVersion + 1L;
        int updatedRowCount = this.delegator.bulkUpdateByAnd(Table.NAME, (Map)FieldMap.build((String)"version", (Object)newVersion), (Map)FieldMap.build((String)"version", (Object)currentVersion).add("id", (Object)portalPageId));
        return updatedRowCount == 1;
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Non caching store.  Nothing to flush.");
    }

    private GenericValue findByPrimaryKey(Long portalPageId) {
        return this.delegator.findById(Table.NAME, portalPageId);
    }

    private PortalPage gvToPortalPage(GenericValue gv) {
        PortalPage portalPage = null;
        if (gv != null) {
            String username = gv.getString("username");
            String layoutString = gv.getString("layout");
            Layout layout = StringUtils.isEmpty((String)layoutString) ? Layout.AA : Layout.valueOf((String)layoutString);
            portalPage = username != null ? PortalPage.id((Long)gv.getLong("id")).name(gv.getString("pagename")).description(gv.getString("description")).owner(gv.getString("username")).favouriteCount(gv.getLong("favCount")).layout(layout).version(gv.getLong("version")).build() : PortalPage.id((Long)gv.getLong("id")).name(gv.getString("pagename")).description(gv.getString("description")).favouriteCount(gv.getLong("favCount")).layout(layout).version(gv.getLong("version")).systemDashboard().build();
        }
        return portalPage;
    }

    private Collection<PortalPage> gvToPortalPages(Collection<GenericValue> gvs) {
        if (gvs == null || gvs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PortalPage> portalPages = new ArrayList<PortalPage>();
        for (GenericValue gv : gvs) {
            portalPages.add(this.gvToPortalPage(gv));
        }
        return portalPages;
    }

    @Nullable
    private String getUserKey(@Nullable String username) {
        return UserNames.toKey(username);
    }

    public static final class Column {
        public static final String PAGENAME = "pagename";
        public static final String VERSION = "version";
        public static final String DESCRIPTION = "description";
        public static final String USERNAME = "username";
        public static final String FAVCOUNT = "favCount";
        public static final String LAYOUT = "layout";
        public static final String ID = "id";
    }

    public static final class Table {
        public static final String NAME = PortalPage.ENTITY_TYPE.getName();
    }
}

