/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class JiraWebResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    private static final String USER_AGENT = "USER-AGENT";
    private static final boolean DEV_MODE = JiraSystemProperties.isDevMode();
    private static final boolean SUPER_BATCHING_DISABLED = JiraSystemProperties.isSuperBatchingDisabled();
    private static final String WEB_RESOURCE_BATCHING_OFF = System.getProperty("plugin.webresource.batching.off");
    private static final List<String> resources = new ArrayList<String>();

    public boolean isSuperBatchingEnabled() {
        return !resources.isEmpty() && !SUPER_BATCHING_DISABLED || this.forceBatchingInThisRequest();
    }

    public boolean isContextBatchingEnabled() {
        return !DEV_MODE || this.forceBatchingInThisRequest();
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        boolean enabled = WEB_RESOURCE_BATCHING_OFF != null ? !Boolean.parseBoolean(WEB_RESOURCE_BATCHING_OFF) : !DEV_MODE;
        return enabled || this.forceBatchingInThisRequest();
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return resources;
    }

    private boolean forceBatchingInThisRequest() {
        if (!DEV_MODE) {
            return false;
        }
        HttpServletRequest httpRequest = ExecutingHttpRequest.get();
        if (httpRequest == null) {
            return false;
        }
        String userAgent = httpRequest.getHeader(USER_AGENT);
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        return userAgentInfo.getBrowser().getBrowserFamily().equals((Object)UserAgentUtil.BrowserFamily.MSIE);
    }

    static {
        resources.add("com.atlassian.auiplugin:ajs");
        resources.add("com.atlassian.auiplugin:aui-experimental-page-layout");
        resources.add("com.atlassian.auiplugin:aui-experimental-page-layout-typography");
        resources.add("jira.webresources:util-lite");
        resources.add("jira.webresources:util");
        resources.add("jira.webresources:inline-layer");
        resources.add("jira.webresources:content-retrievers");
        resources.add("jira.webresources:list");
        resources.add("jira.webresources:dropdown");
        resources.add("jira.webresources:issue-table");
        resources.add("jira.webresources:dropdown-select");
        resources.add("jira.webresources:select-pickers");
        resources.add("jira.webresources:dialogs");
        resources.add("jira.webresources:set-focus");
        resources.add("jira.webresources:jira-global");
        resources.add("jira.webresources:key-commands");
        resources.add("jira.webresources:header");
    }
}

