/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.profile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.profile.OptionalUserProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.plugin.projectpanel.impl.VersionDrillDownRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RoadmapUserProfilePanel
implements ViewProfilePanel,
OptionalUserProfilePanel {
    private static final Logger log = Logger.getLogger(RoadmapUserProfilePanel.class);
    private final VersionDrillDownRenderer panelRenderer;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final VelocityRequestContextFactory requestContextFactory;
    private final ProjectManager projectManager;
    private final UserProjectHistoryManager projectHistoryManager;
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private ViewProfilePanelModuleDescriptor moduleDescriptor;

    public RoadmapUserProfilePanel(VersionDrillDownRenderer panelRenderer, JiraAuthenticationContext authenticationContext, VersionManager versionManager, VelocityRequestContextFactory requestContextFactory, ProjectManager projectManager, UserProjectHistoryManager projectHistoryManager, PermissionManager permissionManager, WebResourceManager webResourceManager, FieldVisibilityManager fieldVisibilityManager) {
        this.panelRenderer = panelRenderer;
        this.authenticationContext = authenticationContext;
        this.versionManager = versionManager;
        this.requestContextFactory = requestContextFactory;
        this.projectManager = projectManager;
        this.projectHistoryManager = projectHistoryManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public void init(ViewProfilePanelModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    @Override
    public boolean showPanel(User profileUser, User currentUser) {
        if (profileUser.equals(currentUser)) {
            for (Project project : this.getApplicableProjects(currentUser)) {
                if (this.versionManager.getVersionsUnreleased(project.getId(), true).isEmpty() || !this.fieldVisibilityManager.isFieldVisible(project.getId(), "fixVersions", "all") || !this.fieldVisibilityManager.isFieldVisible(project.getId(), "assignee", "all")) continue;
                return true;
            }
        }
        return false;
    }

    public String getHtml(User profileUser) {
        User user = this.authenticationContext.getLoggedInUser();
        Project project = this.getProject(user);
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.webResourceManager.requireResource("jira.webresources:expandoSupport");
        BrowseProjectContext ctx = new BrowseProjectContext(user, project);
        params.put("textUtils", new TextUtils());
        params.put("isAjaxExpand", this.isAjaxExpand());
        params.put("browsecontext", ctx);
        params.put("project", ctx.getProject());
        params.put("versionManager", this.versionManager);
        params.put("panelRenderer", this.panelRenderer);
        params.put("browseableProjects", this.getApplicableProjects(user));
        return this.moduleDescriptor.getHtml("view", params);
    }

    private Collection<Project> getApplicableProjects(User user) {
        return this.permissionManager.getProjectObjects(10, user);
    }

    private boolean isAjaxExpand() {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        return StringUtils.isNotBlank((String)requestContext.getRequestParameter("expandVersion")) && StringUtils.isNotBlank((String)requestContext.getRequestParameter("contentOnly"));
    }

    private Project getProject(User currentUser) {
        Project project;
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String projectId = requestContext.getRequestParameter("pid");
        if (StringUtils.isNotBlank((String)projectId) && this.permissionManager.hasPermission(10, project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectId))), currentUser)) {
            this.projectHistoryManager.addProjectToHistory(currentUser, project);
            return project;
        }
        return this.projectHistoryManager.getCurrentProject(10, currentUser);
    }
}

