/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.ProjectResolver;
import com.atlassian.jira.plugin.jql.function.AbstractVersionsFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class EarliestUnreleasedVersionFunction
extends AbstractVersionsFunction {
    public static final String FUNCTION_EARLIEST_UNRELEASED_VERSION = "earliestUnreleasedVersion";
    private final VersionManager versionManager;

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        return super.getValues(queryCreationContext, operand, terminalClause);
    }

    public EarliestUnreleasedVersionFunction(VersionManager versionManager, ProjectResolver projectResolver, PermissionManager permissionManager) {
        super(projectResolver, permissionManager);
        this.versionManager = (VersionManager)Assertions.notNull((String)"versionManager", (Object)versionManager);
    }

    @Override
    protected Collection<Version> getAllVersions(User user) {
        ArrayList<Version> earliestUnreleasedVersions = new ArrayList<Version>();
        Collection projects = this.permissionManager.getProjectObjects(10, user);
        for (Project project : projects) {
            earliestUnreleasedVersions.addAll(this.getVersionsForProject(project.getId()));
        }
        return earliestUnreleasedVersions;
    }

    @Override
    protected Collection<Version> getVersionsForProject(Long projectId) {
        ArrayList<Version> earliestUnreleasedVersion = new ArrayList<Version>();
        Collection allVersions = this.versionManager.getVersionsUnreleased(projectId, true);
        if (allVersions != null && allVersions.size() > 0) {
            TreeSet<Version> sortedVersions = new TreeSet<Version>(new Comparator<Version>(){

                @Override
                public int compare(Version version, Version version1) {
                    return version.getSequence().compareTo(version1.getSequence());
                }
            });
            sortedVersions.addAll(allVersions);
            earliestUnreleasedVersion.add(sortedVersions.first());
        }
        return earliestUnreleasedVersion;
    }
}

