/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.componentpanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.webfragment.model.ComponentHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Map;
import webwork.action.ActionContext;

public class BrowseComponentContextImpl
extends BrowseProjectContext
implements BrowseComponentContext {
    private final SimpleFieldSearchConstantsWithEmpty searchConstants = SystemSearchConstants.forComponent();
    private final SearchService searchService;
    private final ProjectComponent component;
    private TerminalClause componentClause;

    public BrowseComponentContextImpl(SearchService searchService, ProjectComponent component, User user) {
        super(user, null);
        this.searchService = searchService;
        this.component = component;
    }

    public ProjectComponent getComponent() {
        return this.component;
    }

    @Override
    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProjectObj(this.component.getProjectId());
        }
        return this.project;
    }

    @Override
    public Query createQuery() {
        Query superQuery = super.createQuery();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)superQuery);
        builder.where().and().addClause((Clause)this.getComponentSearchClause());
        return builder.buildQuery();
    }

    protected TerminalClause getComponentSearchClause() {
        if (this.componentClause == null) {
            this.componentClause = new TerminalClauseImpl(this.searchConstants.getJqlClauseNames().getPrimaryName(), Operator.EQUALS, this.component.getName());
        }
        return this.componentClause;
    }

    @Override
    public String getQueryString() {
        QueryImpl query = new QueryImpl((Clause)new AndClause(new Clause[]{this.getComponentSearchClause(), this.getProjectClause()}));
        return this.searchService.getQueryString(this.getUser(), (Query)query);
    }

    @Override
    public Map<String, Object> createParameterMap() {
        Map<String, Object> map = super.createParameterMap();
        map.put("component", this.getComponent());
        map.put("helper", this.getHelper());
        return map;
    }

    @Override
    public String getContextKey() {
        return super.getContextKey() + "_component" + this.component.getId();
    }

    private JiraHelper getHelper() {
        return new ComponentHelper(ActionContext.getRequest(), this);
    }
}

