/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.logging;

import com.atlassian.jira.logging.JiraHomeAppender;
import com.atlassian.jira.logging.RollOverLogAppender;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.Tenant;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public class MultiTenantJiraHomeAppender
implements Appender,
OptionHandler,
RollOverLogAppender {
    private volatile MultiTenantComponentMap<Appender> multiTenantAppender;
    private final JiraHomeAppender systemTenantAppender = new JiraHomeAppender(JiraHomeStartupCheck.getInstance());
    private volatile String fileName;

    private Appender getAppender() {
        if (!MultiTenantContext.isEnabled() || !MultiTenantContext.getTenantReference().isSet()) {
            return this.systemTenantAppender;
        }
        return (Appender)this.getMultiTenantAppenders().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiTenantComponentMap<Appender> getMultiTenantAppenders() {
        if (this.multiTenantAppender == null) {
            MultiTenantJiraHomeAppender multiTenantJiraHomeAppender = this;
            synchronized (multiTenantJiraHomeAppender) {
                if (this.multiTenantAppender == null) {
                    this.multiTenantAppender = MultiTenantContext.getFactory().createComponentMap((MultiTenantCreator)new AppenderCreator());
                }
            }
        }
        return this.multiTenantAppender;
    }

    public void addFilter(Filter newFilter) {
        this.getAppender().addFilter(newFilter);
    }

    public Filter getFilter() {
        return this.getAppender().getFilter();
    }

    public Filter getFirstFilter() {
        return this.systemTenantAppender.getFirstFilter();
    }

    public void clearFilters() {
        this.getAppender().clearFilters();
    }

    public void close() {
        this.getAppender().close();
    }

    public String getEncoding() {
        return this.systemTenantAppender.getEncoding();
    }

    public void setEncoding(String value) {
        this.systemTenantAppender.setEncoding(value);
    }

    public void doAppend(LoggingEvent event) {
        this.getAppender().doAppend(event);
    }

    public String getName() {
        return this.getAppender().getName();
    }

    public Priority getThreshold() {
        return this.systemTenantAppender.getThreshold();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getAppender().setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.getAppender().getErrorHandler();
    }

    public void setLayout(Layout layout) {
        this.getAppender().setLayout(layout);
    }

    public Layout getLayout() {
        return this.getAppender().getLayout();
    }

    public void setName(String name) {
        this.getAppender().setName(name);
    }

    public void setThreshold(Priority threshold) {
        this.systemTenantAppender.setThreshold(threshold);
    }

    public boolean requiresLayout() {
        return this.getAppender().requiresLayout();
    }

    public int getMaxBackupIndex() {
        return this.systemTenantAppender.getMaxBackupIndex();
    }

    public long getMaximumFileSize() {
        return this.systemTenantAppender.getMaximumFileSize();
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.systemTenantAppender.setMaxBackupIndex(maxBackups);
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.systemTenantAppender.setMaximumFileSize(maxFileSize);
    }

    public void setMaxFileSize(String value) {
        this.systemTenantAppender.setMaxFileSize(value);
    }

    public void setFile(String file) {
        this.fileName = file;
        this.systemTenantAppender.setFile(file);
    }

    public boolean getAppend() {
        return this.systemTenantAppender.getAppend();
    }

    @Override
    public String getFile() {
        return this.systemTenantAppender.getFile();
    }

    public void activateOptions() {
        this.systemTenantAppender.activateOptions();
    }

    public boolean getBufferedIO() {
        return this.systemTenantAppender.getBufferedIO();
    }

    public int getBufferSize() {
        return this.systemTenantAppender.getBufferSize();
    }

    public void setAppend(boolean flag) {
        this.systemTenantAppender.setAppend(flag);
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.systemTenantAppender.setBufferedIO(bufferedIO);
    }

    public void setBufferSize(int bufferSize) {
        this.systemTenantAppender.setBufferSize(bufferSize);
    }

    public void setImmediateFlush(boolean value) {
        this.systemTenantAppender.setImmediateFlush(value);
    }

    public boolean getImmediateFlush() {
        return this.systemTenantAppender.getImmediateFlush();
    }

    @Override
    public void rollOver() {
        Appender appender = this.getAppender();
        if (appender instanceof RollOverLogAppender) {
            ((RollOverLogAppender)appender).rollOver();
        }
    }

    private class AppenderCreator
    implements MultiTenantCreator<Appender> {
        private AppenderCreator() {
        }

        public Appender create(Tenant tenant) {
            if (tenant == MultiTenantContext.getSystemTenant()) {
                return MultiTenantJiraHomeAppender.this.systemTenantAppender;
            }
            RollingFileAppender appender = new RollingFileAppender();
            appender.setAppend(MultiTenantJiraHomeAppender.this.systemTenantAppender.getAppend());
            appender.setBufferedIO(MultiTenantJiraHomeAppender.this.systemTenantAppender.getBufferedIO());
            appender.setBufferSize(MultiTenantJiraHomeAppender.this.systemTenantAppender.getBufferSize());
            appender.setEncoding(MultiTenantJiraHomeAppender.this.systemTenantAppender.getEncoding());
            appender.setErrorHandler(MultiTenantJiraHomeAppender.this.systemTenantAppender.getErrorHandler());
            appender.setImmediateFlush(MultiTenantJiraHomeAppender.this.systemTenantAppender.getImmediateFlush());
            appender.setLayout(MultiTenantJiraHomeAppender.this.systemTenantAppender.getLayout());
            appender.setMaxBackupIndex(MultiTenantJiraHomeAppender.this.systemTenantAppender.getMaxBackupIndex());
            appender.setMaximumFileSize(MultiTenantJiraHomeAppender.this.systemTenantAppender.getMaximumFileSize());
            appender.setName(MultiTenantJiraHomeAppender.this.systemTenantAppender.getName() + "-" + tenant.getName());
            appender.setThreshold(MultiTenantJiraHomeAppender.this.systemTenantAppender.getThreshold());
            File homeLogFile = JiraHomeAppender.getHomeLogFile(new File(tenant.getHomeDir()), MultiTenantJiraHomeAppender.this.fileName);
            if (homeLogFile != null) {
                appender.setFile(homeLogFile.getAbsolutePath());
            } else {
                appender.setFile(MultiTenantJiraHomeAppender.this.fileName);
            }
            appender.activateOptions();
            return appender;
        }
    }
}

