/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.IssueTypeResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.RawValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;

public class IssueTypeValidator
implements ClauseValidator {
    private final RawValuesExistValidator rawValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final I18nHelper.BeanFactory beanFactory;

    public IssueTypeValidator(IssueTypeResolver issueTypeResolver, JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.rawValuesExistValidator = this.getRawValuesValidator(issueTypeResolver, operandResolver);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.rawValuesExistValidator.validate(searcher, terminalClause);
        }
        return errors;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY});
    }

    RawValuesExistValidator getRawValuesValidator(IssueTypeResolver resolver, JqlOperandResolver operandResolver) {
        return new RawValuesExistValidator(operandResolver, new IssueConstantInfoResolver<IssueType>(resolver), this.beanFactory);
    }
}

