/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.GroupCustomFieldIndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.IndexValuesValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;

public class GroupCustomFieldValidator
implements ClauseValidator {
    private final IndexValuesValidator indexValuesValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver jqlOperandResolver;

    public GroupCustomFieldValidator(JqlOperandResolver jqlOperandResolver, GroupCustomFieldIndexValueConverter groupCustomFieldIndexValueConverter) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
        this.indexValuesValidator = this.getIndexValuesValidator(groupCustomFieldIndexValueConverter);
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.indexValuesValidator.validate(searcher, terminalClause);
        }
        return errors;
    }

    IndexValuesValidator getIndexValuesValidator(GroupCustomFieldIndexValueConverter groupCustomFieldIndexValueConverter) {
        return new IndexValuesValidator(this.jqlOperandResolver, groupCustomFieldIndexValueConverter){

            void addError(MessageSet messageSet, User searcher, TerminalClause terminalClause, QueryLiteral literal) {
                String fieldName = terminalClause.getName();
                if (GroupCustomFieldValidator.this.jqlOperandResolver.isFunctionOperand(literal.getSourceOperand())) {
                    messageSet.addErrorMessage(GroupCustomFieldValidator.this.getI18n(searcher).getText("jira.jql.clause.invalid.group.value.function", literal.getSourceOperand().getName(), fieldName));
                } else {
                    messageSet.addErrorMessage(GroupCustomFieldValidator.this.getI18n(searcher).getText("jira.jql.clause.invalid.group.value", fieldName, literal.asString()));
                }
            }
        };
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY});
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

