/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.SecurityLevelRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecurityLevelJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.statistics.SecurityLevelStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class SecurityLevelSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
RequirableField,
RestAwareField,
RestFieldOperations {
    private static final String SECURITY_LEVEL_NAME_KEY = "issue.field.securitylevel";
    private static final Long NO_SECURITY_LEVEL_ID = -1L;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityLevelStatisticsMapper securityLevelStatisticsMapper;
    private final JiraBaseUrls jiraBaseUrls;

    public SecurityLevelSystemField(VelocityTemplatingEngine templatingEngine, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityLevelStatisticsMapper securityLevelStatisticsMapper, JiraBaseUrls jiraBaseUrls) {
        super("security", SECURITY_LEVEL_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, null);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.securityLevelStatisticsMapper = securityLevelStatisticsMapper;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        if (issue.isSubTask()) {
            velocityParams.put("infoMessageKey", "bulk.edit.security.level.subtask.message");
            return this.renderTemplate("securitylevel-subtask.vm", velocityParams);
        }
        String securityLevelId = (String)operationContext.getFieldValuesHolder().get(this.getId());
        if (securityLevelId != null) {
            velocityParams.put(this.getId(), Long.valueOf(securityLevelId));
        }
        velocityParams.put("securityLevels", this.getUserSecurityLevels(issue));
        velocityParams.put("noneLevelId", NO_SECURITY_LEVEL_ID);
        return this.renderTemplate("securitylevel-edit.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(null, action, null, displayParameters);
        if (bulkEditBean.isSubTaskOnly()) {
            velocityParams.put("infoMessageKey", "bulk.edit.security.level.subtask.message");
            return this.renderTemplate("securitylevel-subtask.vm", velocityParams);
        }
        String securityLevelId = (String)operationContext.getFieldValuesHolder().get(this.getId());
        if (securityLevelId != null) {
            velocityParams.put(this.getId(), Long.valueOf(securityLevelId));
        }
        if (bulkEditBean.getTargetProjectGV() != null) {
            velocityParams.put("securityLevels", this.getUserSecurityLevelsForProject(bulkEditBean.getTargetProjectGV()));
        } else {
            velocityParams.put("securityLevels", this.getUserSecurityLevels(bulkEditBean.getSelectedIssues()));
        }
        velocityParams.put("noneLevelId", NO_SECURITY_LEVEL_ID);
        return this.renderTemplate("securitylevel-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("security", issue.getSecurityLevel());
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("security", value);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("securitylevel-view.vm", velocityParams);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        Iterator iterator = bulkEditBean.getProjects().iterator();
        GenericValue securityScheme = this.getSecurityScheme((GenericValue)iterator.next());
        if (securityScheme == null) {
            return "bulk.edit.unavailable.issuesecurity.noscheme";
        }
        while (iterator.hasNext()) {
            GenericValue securityScheme2 = this.getSecurityScheme((GenericValue)iterator.next());
            if (securityScheme2 == null) {
                return "bulk.edit.unavailable.issuesecurity.noscheme";
            }
            if (securityScheme.equals((Object)securityScheme2)) continue;
            return "bulk.edit.unavailable.issuesecurity.diffschemes";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.issuesecurity.permission";
        }
        return null;
    }

    private List getUserSecurityLevels(Collection issues) {
        Iterator iterator = issues.iterator();
        ArrayList securityLevels = new ArrayList(this.getUserSecurityLevels((Issue)iterator.next()));
        while (iterator.hasNext()) {
            securityLevels.retainAll(this.getUserSecurityLevels((Issue)iterator.next()));
        }
        return securityLevels;
    }

    private List getUserSecurityLevels(Issue issue) {
        try {
            if (issue.getGenericValue() == null) {
                return this.issueSecurityLevelManager.getUsersSecurityLevels(issue.getProject(), this.getAuthenticationContext().getLoggedInUser());
            }
            return this.issueSecurityLevelManager.getUsersSecurityLevels(issue.getGenericValue(), this.getAuthenticationContext().getLoggedInUser());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving security levels.", (Throwable)e);
        }
    }

    private List getUserSecurityLevelsForProject(GenericValue project) {
        try {
            return this.issueSecurityLevelManager.getUsersSecurityLevels(project, this.getAuthenticationContext().getLoggedInUser());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving security levels for project", (Throwable)e);
        }
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        block9: {
            Map fieldValuesHolder = operationContext.getFieldValuesHolder();
            try {
                String securityLevelIdParam = (String)fieldValuesHolder.get(this.getId());
                if (TextUtils.stringSet((String)securityLevelIdParam)) {
                    long securityLevelId = Long.parseLong(securityLevelIdParam);
                    if (securityLevelId > NO_SECURITY_LEVEL_ID) {
                        try {
                            if (this.issueSecurityLevelManager.getIssueSecurityLevel(Long.valueOf(securityLevelId)) == null) {
                                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.security.level.invalid"));
                            }
                            break block9;
                        }
                        catch (GenericEntityException e) {
                            throw new DataAccessException("Error occurred while retrieving security level with id '" + securityLevelId + "'.", (Throwable)e);
                        }
                    }
                    if (fieldScreenRenderLayoutItem.isRequired() && securityLevelId == NO_SECURITY_LEVEL_ID && !issue.isSubTask()) {
                        errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
                    }
                    break block9;
                }
                if (fieldScreenRenderLayoutItem.isRequired() && !issue.isSubTask()) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
                }
            }
            catch (NumberFormatException e) {
                errorCollectionToAddTo.addError(this.getId(), "Invalid security level id '" + fieldValuesHolder.get(this.getId()) + "'.");
            }
        }
    }

    public Object getDefaultValue(Issue issue) {
        return this.getDefaultSecurityLevel((IssueContext)issue);
    }

    private GenericValue getDefaultSecurityLevel(IssueContext issueCtx) {
        try {
            Long defaultSecurityLevelId = this.issueSecurityLevelManager.getSchemeDefaultSecurityLevel(issueCtx.getProject());
            if (defaultSecurityLevelId != null) {
                return this.issueSecurityLevelManager.getIssueSecurityLevel(defaultSecurityLevelId);
            }
            return null;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving default security level.", (Throwable)e);
        }
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        if (!issue.isSubTask()) {
            Object currentValue = modifiedValue.getOldValue();
            Object value = modifiedValue.getNewValue();
            ChangeItemBean cib = null;
            if (currentValue == null) {
                if (value != null) {
                    GenericValue securityGV = (GenericValue)value;
                    cib = new ChangeItemBean("jira", "security", null, null, String.valueOf(securityGV.getLong("id")), securityGV.getString("name"));
                }
            } else if (!this.valuesEqual(value, currentValue)) {
                GenericValue currentSecurityGV = (GenericValue)currentValue;
                if (value != null) {
                    GenericValue securityGV = (GenericValue)value;
                    cib = new ChangeItemBean("jira", "security", String.valueOf(currentSecurityGV.getLong("id")), currentSecurityGV.getString("name"), String.valueOf(securityGV.getLong("id")), securityGV.getString("name"));
                } else {
                    cib = new ChangeItemBean("jira", "security", String.valueOf(currentSecurityGV.getLong("id")), currentSecurityGV.getString("name"), null, null);
                }
            }
            if (cib != null) {
                Collection subTasks = issue.getSubTasks();
                if (!subTasks.isEmpty()) {
                    for (GenericValue subTask : subTasks) {
                        subTask.set(this.getId(), value == null ? null : ((GenericValue)value).getLong("id"));
                        try {
                            subTask.store();
                        }
                        catch (GenericEntityException e) {
                            throw new DataAccessException("Could not update security level of sub-task.", (Throwable)e);
                        }
                    }
                    issueChangeHolder.setSubtasksUpdated(true);
                }
                issueChangeHolder.addChangeItem(cib);
            }
        }
    }

    public void createValue(Issue issue, Object value) {
    }

    public Object getValueFromParams(Map params) {
        if (params.containsKey(this.getId()) && params.get(this.getId()) != null) {
            Long securityLevelId = Long.valueOf((String)params.get(this.getId()));
            if (NO_SECURITY_LEVEL_ID.equals(securityLevelId)) {
                return null;
            }
            return this.getSecurityLevel(securityLevelId);
        }
        return null;
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        Long securityLevelId;
        try {
            securityLevelId = Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            securityLevelId = this.getSecurityLevelIdByName(issue, stringValue);
        }
        fieldValuesHolder.put(this.getId(), securityLevelId.toString());
    }

    public List<IssueSearcher<?>> getAssociatedSearchers() {
        return Collections.emptyList();
    }

    private Long getSecurityLevelIdByName(Issue issue, String stringValue) throws FieldValidationException {
        List userSecurityLevels = this.getUserSecurityLevels(issue);
        for (GenericValue securityLevelGV : userSecurityLevels) {
            if (!stringValue.equalsIgnoreCase(securityLevelGV.getString("name"))) continue;
            return Long.valueOf(securityLevelGV.getString("id"));
        }
        throw new FieldValidationException("Invalid security level name '" + stringValue + "'.");
    }

    private GenericValue getSecurityLevel(Long securityLevelId) {
        if (securityLevelId == null) {
            return null;
        }
        try {
            return this.issueSecurityLevelManager.getIssueSecurityLevel(securityLevelId);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving security level with id '" + securityLevelId + "'.", (Throwable)e);
        }
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        GenericValue securityLevel = issue.getSecurityLevel();
        if (securityLevel != null) {
            fieldValuesHolder.put(this.getId(), securityLevel.getLong("id").toString());
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        GenericValue defaultSecurityLevel = (GenericValue)this.getDefaultValue(issue);
        if (defaultSecurityLevel != null) {
            fieldValuesHolder.put(this.getId(), defaultSecurityLevel.getLong("id").toString());
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 26) && this.hasSecurityScheme(issue.getProject());
    }

    private boolean hasSecurityScheme(GenericValue project) {
        return this.getSecurityScheme(project) != null;
    }

    protected GenericValue getSecurityScheme(GenericValue project) {
        try {
            List schemes = this.issueSecuritySchemeManager.getSchemes(project);
            return schemes == null || schemes.isEmpty() ? null : (GenericValue)schemes.iterator().next();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (issue.isSubTask()) {
            Issue parentObject = issue.getParentObject();
            if (parentObject != null) {
                issue.setSecurityLevel(parentObject.getSecurityLevel());
            }
        } else if (fieldValueHolder.containsKey(this.getId())) {
            issue.setSecurityLevel((GenericValue)this.getValueFromParams(fieldValueHolder));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        Long defaultSecurityLevel;
        try {
            defaultSecurityLevel = this.issueSecurityLevelManager.getSchemeDefaultSecurityLevel(targetIssue.getProject());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving the default issue security level.", (Throwable)e);
        }
        for (Issue originalIssue : originalIssues) {
            if (originalIssue.getSecurityLevel() == null) {
                if (targetFieldLayoutItem.isRequired()) {
                    return new MessagedResult(true);
                }
                if (defaultSecurityLevel == null || !this.issueMovedProject(originalIssue, targetIssue)) continue;
                return new MessagedResult(true);
            }
            if (this.getUserSecurityLevels(targetIssue).contains(originalIssue.getSecurityLevel())) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    private boolean issueMovedProject(Issue originalIssue, Issue targetIssue) {
        if (originalIssue.getProjectObject() == null) {
            throw new IllegalArgumentException("Null project for originalIssue '" + originalIssue.getKey() + "'");
        }
        if (targetIssue.getProjectObject() == null) {
            throw new IllegalArgumentException("Null project for targetIssue '" + targetIssue.getKey() + "'");
        }
        return !originalIssue.getProjectObject().getId().equals(targetIssue.getProjectObject().getId());
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        this.populateDefaults(fieldValuesHolder, targetIssue);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        if (issue.isSubTask()) {
            return;
        }
        issue.setSecurityLevel(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return !issue.isSubTask();
    }

    public boolean hasValue(Issue issue) {
        return issue.getSecurityLevel() != null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.securitylevel";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.securityLevelStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put(this.getId(), issue.getSecurityLevel());
        return this.renderTemplate("securitylevel-columnview.vm", velocityParams);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        List issueSecurityLevels = this.issueSecurityLevelManager.getUsersSecurityLevels(fieldTypeInfoContext.getIssueContext().getProjectObject(), this.getAuthenticationContext().getLoggedInUser());
        Collection allowedValues = SecurityLevelJsonBean.shortBeans((Collection)issueSecurityLevels, (JiraBaseUrls)this.jiraBaseUrls);
        return new FieldTypeInfo(allowedValues, null);
    }

    public JsonType getJsonSchema() {
        return SecurityLevelSystemField.getSecurityLevelJsonSchema();
    }

    public static JsonType getSecurityLevelJsonSchema() {
        return JsonTypeBuilder.system((String)"securitylevel", (String)"security");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Long securityLevelId = issue.getSecurityLevelId();
        if (securityLevelId == null) {
            return new FieldJsonRepresentation(null);
        }
        IssueSecurityLevel securityLevel = this.issueSecurityLevelManager.getSecurityLevel(securityLevelId.longValue());
        return new FieldJsonRepresentation(new JsonData((Object)SecurityLevelJsonBean.shortBean((IssueSecurityLevel)securityLevel, (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new SecurityLevelRestFieldOperationsHandler(this.issueSecurityLevelManager, this.authenticationContext, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        GenericValue gv = this.getDefaultSecurityLevel(issueCtx);
        if (gv != null) {
            return new JsonData((Object)EasyMap.build((Object)"id", (Object)gv.get("id").toString()));
        }
        return null;
    }
}

