/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.jira.crowd.embedded.ofbiz.EntityAttributeCondition;
import com.atlassian.jira.crowd.embedded.ofbiz.NullEntityAttributeCondition;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

abstract class EntityConditionFactory {
    EntityConditionFactory() {
    }

    abstract String getEntityTableIdColumnName();

    abstract String getAttributeTableName();

    abstract String getAttributeIdColumnName();

    abstract String getLowerFieldName(Property<?> var1);

    abstract boolean isCoreProperty(Property<?> var1);

    EntityCondition getEntityConditionFor(SearchRestriction restriction) {
        if (restriction == null || restriction instanceof NullRestriction) {
            return null;
        }
        if (restriction instanceof BooleanRestriction) {
            return this.parseBooleanRestriction((BooleanRestriction)restriction);
        }
        if (restriction instanceof PropertyRestriction) {
            return this.parsePropertyRestriction((PropertyRestriction)restriction);
        }
        throw new UnsupportedOperationException("Unknown SearchRestriction type " + restriction.getClass());
    }

    private EntityCondition parsePropertyRestriction(PropertyRestriction<?> propertyRestriction) {
        if (this.isCoreProperty(propertyRestriction.getProperty())) {
            return this.parseCorePropertyRestriction(propertyRestriction);
        }
        return this.parseAttributePropertyRestriction(propertyRestriction);
    }

    private EntityCondition parseCorePropertyRestriction(PropertyRestriction<?> restriction) {
        switch (restriction.getMatchMode()) {
            case EXACTLY_MATCHES: {
                return this.makeCaseInsensitiveEntityCondition(restriction, EntityOperator.EQUALS, restriction.getValue());
            }
            case GREATER_THAN: {
                return this.makeCaseInsensitiveEntityCondition(restriction, EntityOperator.GREATER_THAN, restriction.getValue());
            }
            case LESS_THAN: {
                return this.makeCaseInsensitiveEntityCondition(restriction, EntityOperator.LESS_THAN, restriction.getValue());
            }
            case CONTAINS: {
                return this.makeCaseInsensitiveEntityCondition(restriction, EntityOperator.LIKE, "%" + restriction.getValue() + "%");
            }
            case STARTS_WITH: {
                return this.makeCaseInsensitiveEntityCondition(restriction, EntityOperator.LIKE, restriction.getValue() + "%");
            }
            case NULL: {
                return this.makeCaseInsensitiveEntityCondition(restriction, EntityOperator.EQUALS, null);
            }
        }
        throw new UnsupportedOperationException("Unknown Match Mode: " + restriction.getMatchMode());
    }

    private EntityCondition parseAttributePropertyRestriction(PropertyRestriction<?> restriction) {
        switch (restriction.getMatchMode()) {
            case EXACTLY_MATCHES: {
                return this.makeCaseInsensitiveAttributeCondition(restriction, " = ", restriction.getValue());
            }
            case GREATER_THAN: {
                return this.makeCaseInsensitiveAttributeCondition(restriction, " > ", restriction.getValue());
            }
            case LESS_THAN: {
                return this.makeCaseInsensitiveAttributeCondition(restriction, " < ", restriction.getValue());
            }
            case CONTAINS: {
                return this.makeCaseInsensitiveAttributeCondition(restriction, " LIKE ", "%" + restriction.getValue() + "%");
            }
            case STARTS_WITH: {
                return this.makeCaseInsensitiveAttributeCondition(restriction, " LIKE ", restriction.getValue() + "%");
            }
            case NULL: {
                return this.makeNullAttributeCondition(restriction);
            }
        }
        throw new UnsupportedOperationException("Unknown Match Mode: " + restriction.getMatchMode());
    }

    private EntityCondition makeCaseInsensitiveEntityCondition(PropertyRestriction<?> restriction, EntityOperator operator, Object value) {
        Property property = restriction.getProperty();
        if (property.getPropertyType().equals(String.class)) {
            String lowerName = this.getLowerFieldName(property);
            if (lowerName != null) {
                String strValue = value == null ? null : IdentifierUtils.toLowerCase((String)((String)value));
                return new EntityExpr(lowerName, operator, (Object)strValue);
            }
            return new EntityExpr(property.getPropertyName(), operator, value);
        }
        if (property.getPropertyType().equals(Boolean.class)) {
            Integer intValue = BooleanUtils.toIntegerObject((Boolean)((Boolean)value));
            return new EntityExpr(property.getPropertyName(), operator, (Object)intValue);
        }
        if (property.getPropertyType().equals(Date.class)) {
            Timestamp timestampValue = new Timestamp(((Date)value).getTime());
            return new EntityExpr(property.getPropertyName(), operator, (Object)timestampValue);
        }
        throw new IllegalArgumentException("Unrecognised PropertyType '" + property.getPropertyType().getName() + "'.");
    }

    private EntityCondition makeCaseInsensitiveAttributeCondition(PropertyRestriction<?> restriction, String operator, Object value) {
        Property property = restriction.getProperty();
        String strValue = value == null ? null : IdentifierUtils.toLowerCase((String)value.toString());
        StringBuilder builder = new StringBuilder(this.getEntityTableIdColumnName());
        builder.append(" IN (SELECT ").append(this.getAttributeIdColumnName());
        builder.append(" FROM ").append(this.getAttributeTableName());
        builder.append(" WHERE attribute_name = ? AND lower_attribute_value");
        builder.append(operator);
        builder.append(" ? )");
        return new EntityAttributeCondition(builder.toString(), property.getPropertyName(), strValue);
    }

    private EntityCondition makeNullAttributeCondition(PropertyRestriction<?> restriction) {
        Property property = restriction.getProperty();
        StringBuilder builder = new StringBuilder(this.getEntityTableIdColumnName());
        builder.append(" NOT IN (SELECT ").append(this.getAttributeIdColumnName());
        builder.append(" FROM ").append(this.getAttributeTableName());
        builder.append(" WHERE attribute_name = ? )");
        return new NullEntityAttributeCondition(builder.toString(), property.getPropertyName());
    }

    private EntityCondition parseBooleanRestriction(BooleanRestriction booleanRestriction) {
        ArrayList<EntityCondition> entityConditions = new ArrayList<EntityCondition>();
        for (SearchRestriction searchRestriction : booleanRestriction.getRestrictions()) {
            EntityCondition condition = this.getEntityConditionFor(searchRestriction);
            if (condition == null) {
                if (booleanRestriction.getBooleanLogic() != BooleanRestriction.BooleanLogic.OR) continue;
                return null;
            }
            entityConditions.add(condition);
        }
        return new EntityConditionList(entityConditions, this.getOperator(booleanRestriction));
    }

    private EntityOperator getOperator(BooleanRestriction booleanRestriction) throws UnsupportedOperationException {
        switch (booleanRestriction.getBooleanLogic()) {
            case AND: {
                return EntityOperator.AND;
            }
            case OR: {
                return EntityOperator.OR;
            }
        }
        throw new UnsupportedOperationException("Unknown Boolean Logic: " + booleanRestriction.getBooleanLogic());
    }
}

