/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.AbstractDatabaseConfig;
import com.atlassian.jira.configurator.db.ConfigField;
import com.atlassian.jira.configurator.db.DatabaseConfigConsole;
import com.atlassian.jira.configurator.db.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;

public class HsqlDatabaseConfig
extends AbstractDatabaseConfig
implements DatabaseConfigConsole {
    private final String PREFIX = "jdbc:hsqldb:";
    private final String SUFFIX = "/database/jiradb";
    private String jiraHome;

    @Override
    public String getDatabaseType() {
        return "HSQL";
    }

    @Override
    public String getInstanceFieldName() {
        return "Database";
    }

    @Override
    public String getClassName() {
        return "org.hsqldb.jdbcDriver";
    }

    @Override
    public String getUsername() {
        return "sa";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public ConfigField[] getFields() {
        return null;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        this.jiraHome = settings.getJiraHome();
    }

    @Override
    public String getInstanceName() {
        return "(unused)";
    }

    @Override
    public void saveSettings(Settings newSettings) throws ValidationException {
        newSettings.getJdbcDatasourceBuilder().setDriverClassName(this.getClassName()).setJdbcUrl(this.getUrl()).setUsername(this.getUsername()).setPassword(this.getPassword());
    }

    @Override
    public void testConnection() {
    }

    @Override
    public String getUrl() {
        return "jdbc:hsqldb:" + this.jiraHome + "/database/jiradb";
    }

    @Override
    public String getUrl(String hostname, String port, String instance) {
        return this.getUrl();
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        if (!jdbcUrl.startsWith("jdbc:hsqldb:") || !jdbcUrl.endsWith("/database/jiradb")) {
            throw new ParseException("Unable to parse the HSQL JDBC URL '" + jdbcUrl + "'.");
        }
        String stripped = jdbcUrl.substring("jdbc:hsqldb:".length());
        this.jiraHome = stripped.substring(0, stripped.length() - "/database/jiradb".length());
        return new DatabaseInstance();
    }

    @Override
    protected String getProtocolPrefix() {
        return "jdbc:hsqldb:";
    }
}

