/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork.actions;

import com.atlassian.jira.security.Permissions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nullable;
import webwork.config.Configuration;
import webwork.config.util.ActionInfo;

public interface ActionConfiguration {
    public Entry getActionCommand(String var1);

    public static class Entry {
        private String name;
        private String command;
        private Iterable<Integer> permissionsRequired;

        public Entry(String name, String command, Iterable<Integer> permissionsRequired) {
            this.name = name;
            this.command = command;
            this.permissionsRequired = permissionsRequired;
        }

        public String toActionFactoryString() {
            if (Strings.isNullOrEmpty((String)this.command)) {
                return this.name;
            }
            return this.name + "!" + this.command;
        }

        public static EntryBuilder newBuilder() {
            return new EntryBuilder();
        }

        public Iterable<Integer> getPermissionsRequired() {
            return this.permissionsRequired;
        }

        public static class EntryBuilder {
            private String name;
            private String command = "";
            private String rolesRequired;

            public EntryBuilder className(String name) {
                this.name = name;
                return this;
            }

            public EntryBuilder commandMethod(String command) {
                this.command = command;
                return this;
            }

            public EntryBuilder rolesRequired(String rolesRequired) {
                this.rolesRequired = rolesRequired;
                return this;
            }

            public Entry build() {
                return new Entry(this.name, this.command, this.transformRolesToPermissions(this.rolesRequired));
            }

            private Iterable<Integer> transformRolesToPermissions(@Nullable String roles) {
                if (roles == null) {
                    return Collections.emptyList();
                }
                Iterable splitRoles = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)roles);
                return Iterables.transform((Iterable)splitRoles, (Function)new Function<String, Integer>(){

                    public Integer apply(@Nullable String input) {
                        return Permissions.getType((String)input);
                    }
                });
            }
        }
    }

    public static class FromWebWorkConfiguration
    implements ActionConfiguration {
        @Override
        @Nullable
        public Entry getActionCommand(String alias) {
            try {
                return Entry.newBuilder().className(this.parseActionClassFrom(this.getActionMappingEntryFor(alias))).commandMethod(this.parseCommandMethodFrom(this.getActionMappingEntryFor(alias))).rolesRequired(this.getRolesRequiredMappingEntryFor(alias)).build();
            }
            catch (IllegalArgumentException aliasNotFound) {
                ActionInfo actionMappingForAlias = this.getActionInfoMappingEntryFor(alias);
                if (actionMappingForAlias != null && "".equals(actionMappingForAlias.getActionAlias())) {
                    return Entry.newBuilder().className(alias).rolesRequired(this.getRolesRequiredMappingEntryFor(alias)).build();
                }
                return null;
            }
        }

        private String parseCommandMethodFrom(String actionNameAndCommand) {
            if (actionNameAndCommand.contains("!")) {
                Iterables.getLast((Iterable)Splitter.on((char)'!').split((CharSequence)actionNameAndCommand));
            }
            return "";
        }

        private String parseActionClassFrom(String actionNameAndCommand) {
            if (actionNameAndCommand.contains("!")) {
                Iterables.getFirst((Iterable)Splitter.on((char)'!').split((CharSequence)actionNameAndCommand), (Object)"");
            }
            return actionNameAndCommand;
        }

        private String getRolesRequiredMappingEntryFor(String alias) {
            return this.getStringFromConfiguration(alias + ".actionRoles");
        }

        private String getActionMappingEntryFor(String alias) {
            return this.getStringFromConfiguration(alias + "." + this.getStringFromConfiguration("webwork.action.extension"));
        }

        private ActionInfo getActionInfoMappingEntryFor(String alias) {
            return (ActionInfo)this.getObjectFromConfiguration(alias + ".actionInfo");
        }

        @VisibleForTesting
        Object getObjectFromConfiguration(String key) {
            return Configuration.get((String)key);
        }

        @VisibleForTesting
        String getStringFromConfiguration(String key) {
            return Configuration.getString((String)key);
        }
    }
}

